<?php $__env->startSection('title', 'Due Report'); ?>
<?php $__env->startSection('page-title', 'Due Report'); ?>

<?php $__env->startSection('content'); ?>
<style>
    @media print {
        .no-print { display: none !important; }
        .card { border: none !important; box-shadow: none !important; }
    }
</style>

<div class="card no-print mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('partner.reports.due')); ?>" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Due Within (Days)</label>
                <input type="number" name="days" class="form-control" value="<?php echo e(request('days')); ?>" placeholder="e.g., 30">
                <small class="text-muted">Show loans due within this many days</small>
            </div>
            <div class="col-md-4 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="<?php echo e(route('partner.reports.due')); ?>" class="btn btn-secondary">Reset</a>
                <button type="button" onclick="window.print()" class="btn btn-info">
                    <i class="bi bi-printer me-2"></i>Print
                </button>
            </div>
        </form>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Due</h6>
                <h3 style="color: var(--text-heading);"><?php echo e($summary['total_due']); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Amount</h6>
                <h3 style="color: var(--text-heading);">₹<?php echo e(number_format($summary['total_amount'], 2)); ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Upcoming Due Loans</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Loan #</th>
                        <th>Customer</th>
                        <th>Scheme</th>
                        <th>Due Date</th>
                        <th class="text-end">Days Until Due</th>
                        <th class="text-end">Outstanding</th>
                        <th class="text-end">Installment</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($loan->loan_number); ?></td>
                        <td><?php echo e($loan->customer->name); ?></td>
                        <td><?php echo e($loan->loanScheme?->name ?? $loan->scheme?->name ?? 'N/A'); ?></td>
                        <td><?php echo e($loan->due_date->format('d M Y')); ?></td>
                        <td class="text-end">
                            <span class="badge bg-<?php echo e($loan->days_until_due <= 7 ? 'warning' : 'info'); ?>">
                                <?php echo e($loan->days_until_due); ?> days
                            </span>
                        </td>
                        <td class="text-end text-warning">₹<?php echo e(number_format($loan->remaining_amount, 2)); ?></td>
                        <td class="text-end">₹<?php echo e(number_format($loan->monthly_installment, 2)); ?></td>
                        <td>
                            <span class="badge bg-success">Active</span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No due loans found</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
                <?php if($loans->count() > 0): ?>
                <tfoot>
                    <tr class="table-info">
                        <td colspan="4" class="text-end"><strong>Total:</strong></td>
                        <td></td>
                        <td class="text-end"><strong>₹<?php echo e(number_format($loans->sum('remaining_amount'), 2)); ?></strong></td>
                        <td class="text-end"><strong>₹<?php echo e(number_format($loans->sum('monthly_installment'), 2)); ?></strong></td>
                        <td></td>
                    </tr>
                </tfoot>
                <?php endif; ?>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\micro-master\resources\views/partner/reports/due.blade.php ENDPATH**/ ?>