<?php $__env->startSection('title', 'Customers'); ?>
<?php $__env->startSection('page-title', 'Customers'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Customers</h5>
        <a href="<?php echo e(route('partner.customers.create')); ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add Customer
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Photo</th>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <?php if($customer->photo): ?>
                                <img src="<?php echo e(Storage::url($customer->photo)); ?>" alt="<?php echo e($customer->name); ?>" 
                                     class="rounded" style="width: 40px; height: 40px; object-fit: cover;">
                            <?php else: ?>
                                <div class="bg-secondary rounded d-flex align-items-center justify-content-center" 
                                     style="width: 40px; height: 40px;">
                                    <i class="bi bi-person" style="font-size: 20px; color: var(--text-secondary);"></i>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($customer->customer_code); ?></td>
                        <td><?php echo e($customer->name); ?></td>
                        <td><?php echo e($customer->phone); ?></td>
                        <td><?php echo e($customer->email ?? 'N/A'); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($customer->status === 'active' ? 'success' : 'secondary'); ?>">
                                <?php echo e(ucfirst($customer->status)); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('partner.customers.show', $customer)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="<?php echo e(route('partner.customers.edit', $customer)); ?>" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center">No customers found.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            <?php echo e($customers->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\micro-master\resources\views/partner/customers/index.blade.php ENDPATH**/ ?>