

<?php $__env->startSection('title', 'Repayment Report'); ?>
<?php $__env->startSection('page-title', 'Repayment Report'); ?>

<?php $__env->startSection('content'); ?>
<style>
    @media print {
        .no-print { display: none !important; }
        .card { border: none !important; box-shadow: none !important; }
    }
</style>

<div class="card no-print mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('partner.reports.repayments')); ?>" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="on_time" <?php echo e(request('status') === 'on_time' ? 'selected' : ''); ?>>On Time</option>
                    <option value="overdue" <?php echo e(request('status') === 'overdue' ? 'selected' : ''); ?>>Overdue</option>
                    <option value="late" <?php echo e(request('status') === 'late' ? 'selected' : ''); ?>>Late</option>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="<?php echo e(route('partner.reports.repayments')); ?>" class="btn btn-secondary">Reset</a>
                <button type="button" onclick="window.print()" class="btn btn-info">
                    <i class="bi bi-printer me-2"></i>Print
                </button>
            </div>
        </form>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Repayments</h6>
                <h3 style="color: var(--text-heading);"><?php echo e($summary['total_repayments']); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Amount</h6>
                <h3 style="color: var(--text-heading);">₹<?php echo e(number_format($summary['total_amount'], 2)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Principal</h6>
                <h3 style="color: var(--success);">₹<?php echo e(number_format($summary['total_principal'], 2)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Interest</h6>
                <h3 style="color: var(--info);">₹<?php echo e(number_format($summary['total_interest'], 2)); ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Repayment Details</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Repayment #</th>
                        <th>Loan #</th>
                        <th>Customer</th>
                        <th>Payment Date</th>
                        <th class="text-end">Amount</th>
                        <th class="text-end">Principal</th>
                        <th class="text-end">Interest</th>
                        <th class="text-end">Penalty</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $repayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $repayment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($repayment->repayment_number); ?></td>
                        <td><?php echo e($repayment->loan->loan_number); ?></td>
                        <td><?php echo e($repayment->customer->name); ?></td>
                        <td><?php echo e($repayment->payment_date->format('d M Y')); ?></td>
                        <td class="text-end">₹<?php echo e(number_format($repayment->amount, 2)); ?></td>
                        <td class="text-end">₹<?php echo e(number_format($repayment->principal_amount, 2)); ?></td>
                        <td class="text-end">₹<?php echo e(number_format($repayment->interest_amount, 2)); ?></td>
                        <td class="text-end">₹<?php echo e(number_format($repayment->penalty_amount, 2)); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($repayment->status === 'on_time' ? 'success' : 'warning'); ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $repayment->status))); ?>

                            </span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No repayments found</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
                <?php if($repayments->count() > 0): ?>
                <tfoot>
                    <tr class="table-info">
                        <td colspan="4" class="text-end"><strong>Total:</strong></td>
                        <td class="text-end"><strong>₹<?php echo e(number_format($summary['total_amount'], 2)); ?></strong></td>
                        <td class="text-end"><strong>₹<?php echo e(number_format($summary['total_principal'], 2)); ?></strong></td>
                        <td class="text-end"><strong>₹<?php echo e(number_format($summary['total_interest'], 2)); ?></strong></td>
                        <td class="text-end"><strong>₹<?php echo e(number_format($summary['total_penalty'], 2)); ?></strong></td>
                        <td></td>
                    </tr>
                </tfoot>
                <?php endif; ?>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\micro-master\resources\views/partner/reports/repayments.blade.php ENDPATH**/ ?>