<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Micro Loan Management'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <?php echo $__env->yieldPushContent('styles'); ?>
    <style>
        :root {
            --primary: #7367f0;
            --primary-dark: #5e50ee;
            --primary-light: #9e95f5;
            --secondary: #82868b;
            --success: #28c76f;
            --warning: #ff9f43;
            --danger: #ea5455;
            --info: #00cfe8;
            --sidebar-width: 260px;
            --header-height: 70px;
        }

        /* Dark Theme (Default) */
        [data-theme="dark"] {
            --bg-primary: #161d31;
            --bg-secondary: #283046;
            --bg-card: #283046;
            --bg-sidebar: #161d31;
            --text-primary: #b4b7bd;
            --text-secondary: #676d7d;
            --text-heading: #ffffff;
            --border-color: rgba(255,255,255,0.05);
            --border-light: rgba(255,255,255,0.1);
            --hover-bg: rgba(255,255,255,0.05);
            --hover-bg-light: rgba(255,255,255,0.1);
        }

        /* Light Theme */
        [data-theme="light"] {
            --bg-primary: #f8f9fa;
            --bg-secondary: #ffffff;
            --bg-card: #ffffff;
            --bg-sidebar: #ffffff;
            --text-primary: #1a1a1a;
            --text-secondary: #2c3e50;
            --text-heading: #000000;
            --border-color: rgba(0,0,0,0.08);
            --border-light: rgba(0,0,0,0.12);
            --hover-bg: rgba(0,0,0,0.04);
            --hover-bg-light: rgba(0,0,0,0.06);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html, body {
            margin: 0;
            padding: 0;
            overflow-x: hidden;
            width: 100%;
            height: 100%;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: var(--bg-primary);
            color: var(--text-primary);
            font-size: 14px;
            line-height: 1.5;
            transition: background-color 0.3s ease, color 0.3s ease;
            width: 100%;
            box-sizing: border-box;
            position: relative;
        }

        * {
            box-sizing: border-box;
        }

        /* Force text visibility in light theme */
        [data-theme="light"] body,
        [data-theme="light"] .page-content,
        [data-theme="light"] .card,
        [data-theme="light"] .card-body {
            color: var(--text-primary) !important;
        }

        /* Sidebar Styles */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: var(--bg-sidebar);
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
            z-index: 1000;
            transition: transform 0.3s ease, background 0.3s ease;
            overflow-y: auto;
            overflow-x: hidden;
            isolation: isolate;
        }

        [data-theme="light"] .sidebar {
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            border-right: 1px solid rgba(0,0,0,0.1);
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(255,255,255,0.1);
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(255,255,255,0.2);
        }

        [data-theme="light"] .sidebar::-webkit-scrollbar-thumb {
            background: rgba(0,0,0,0.2);
        }

        [data-theme="light"] .sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(0,0,0,0.3);
        }

        .sidebar-header {
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 12px;
            border-bottom: 1px solid var(--border-color);
        }

        .sidebar-logo {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            font-weight: 700;
        }

        .sidebar-brand {
            font-size: 22px;
            font-weight: 700;
            color: white;
        }

        [data-theme="light"] .sidebar-brand {
            color: var(--text-heading);
        }

        .sidebar-menu {
            padding: 20px 0;
        }

        .menu-section-title {
            padding: 15px 20px 8px;
            font-size: 11px;
            font-weight: 600;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        [data-theme="light"] .menu-section-title {
            color: var(--text-secondary);
        }

        .menu-item {
            padding: 0 20px;
            margin-bottom: 4px;
        }

        .menu-link {
            display: flex;
            align-items: center;
            padding: 12px 16px;
            color: var(--text-primary);
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.2s ease;
            position: relative;
        }

        [data-theme="light"] .menu-link {
            color: var(--text-primary);
        }

        .menu-link:hover {
            background: rgba(115, 103, 240, 0.1);
            color: var(--primary-light);
            transform: translateX(4px);
        }

        [data-theme="light"] .menu-link:hover {
            background: rgba(115, 103, 240, 0.1);
            color: var(--primary);
        }

        .menu-link.active {
            background: linear-gradient(135deg, rgba(115, 103, 240, 0.15) 0%, rgba(115, 103, 240, 0.05) 100%);
            color: var(--text-heading);
            box-shadow: 0 0 20px rgba(115, 103, 240, 0.3);
        }

        [data-theme="light"] .menu-link.active {
            background: linear-gradient(135deg, rgba(115, 103, 240, 0.15) 0%, rgba(115, 103, 240, 0.05) 100%);
            color: var(--primary);
            box-shadow: 0 0 20px rgba(115, 103, 240, 0.2);
        }

        .menu-link.active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 3px;
            height: 70%;
            background: var(--primary);
            border-radius: 0 3px 3px 0;
        }

        .menu-icon {
            width: 20px;
            height: 20px;
            margin-right: 12px;
            font-size: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .menu-text {
            flex: 1;
            font-weight: 500;
        }

        .menu-badge {
            padding: 3px 8px;
            font-size: 11px;
            font-weight: 600;
            border-radius: 12px;
            background: var(--primary);
            color: white;
        }

        /* Main Content */
        .main-content {
            position: relative;
            margin-left: var(--sidebar-width);
            width: calc(100vw - var(--sidebar-width));
            min-height: 100vh;
            padding-top: var(--header-height);
            overflow-x: hidden;
            z-index: 1;
            background: var(--bg-primary);
        }

        /* Header / Navbar */
        .navbar-custom {
            position: fixed;
            top: 0;
            left: var(--sidebar-width);
            right: 0;
            height: var(--header-height);
            background: var(--bg-secondary);
            border-bottom: 1px solid var(--border-color);
            padding: 0 30px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            z-index: 999;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: background 0.3s ease, border-color 0.3s ease, left 0.3s ease;
        }

        .navbar-left {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .mobile-menu-toggle {
            display: none;
            width: 40px;
            height: 40px;
            border: none;
            background: rgba(255,255,255,0.05);
            color: white;
            border-radius: 8px;
            cursor: pointer;
            font-size: 20px;
        }

        .search-box {
            position: relative;
            width: 400px;
        }

        .search-box input {
            width: 100%;
            padding: 10px 40px 10px 45px;
            background: var(--hover-bg);
            border: 1px solid var(--border-light);
            border-radius: 8px;
            color: var(--text-heading);
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .search-box input:focus {
            outline: none;
            border-color: var(--primary);
            background: var(--hover-bg-light);
            box-shadow: 0 0 0 3px rgba(115, 103, 240, 0.1);
        }

        .search-box input::placeholder {
            color: var(--text-secondary);
        }

        .search-box .search-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
            font-size: 18px;
        }

        .navbar-right {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .nav-icon-btn {
            width: 40px;
            height: 40px;
            border: none;
            background: var(--hover-bg);
            color: var(--text-primary);
            border-radius: 8px;
            cursor: pointer;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s ease;
        }

        .nav-icon-btn:hover {
            background: var(--hover-bg-light);
            color: var(--text-heading);
        }

        .theme-toggle-btn {
            width: 40px;
            height: 40px;
            border: none;
            background: var(--hover-bg);
            color: var(--text-primary);
            border-radius: 8px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s ease;
            font-size: 18px;
        }

        .theme-toggle-btn:hover {
            background: var(--hover-bg-light);
            color: var(--primary);
            transform: rotate(180deg);
        }

        .nav-icon-btn .badge {
            position: absolute;
            top: -5px;
            right: -5px;
            background: var(--danger);
            color: white;
            font-size: 10px;
            padding: 3px 6px;
            border-radius: 10px;
            font-weight: 700;
        }

        .user-dropdown {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 8px 12px;
            background: var(--hover-bg);
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .user-dropdown:hover {
            background: var(--hover-bg-light);
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 14px;
        }

        .user-info {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            color: var(--text-heading);
            font-weight: 600;
            font-size: 14px;
        }

        .user-role {
            color: var(--text-secondary);
            font-size: 12px;
        }

        /* Page Content */
        .page-content {
            padding: 30px;
            max-width: 100%;
            overflow-x: hidden;
        }

        .page-header {
            margin-bottom: 30px;
        }

        .page-title {
            font-size: 28px;
            font-weight: 700;
            color: var(--text-heading);
            margin-bottom: 5px;
        }

        .page-breadcrumb {
            display: flex;
            align-items: center;
            gap: 8px;
            color: var(--text-secondary);
            font-size: 14px;
        }

        .page-breadcrumb a {
            color: var(--text-secondary);
            text-decoration: none;
        }

        .page-breadcrumb a:hover {
            color: var(--primary);
        }

        /* Cards */
        .card {
            background: var(--bg-card);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 24px;
            color: var(--text-primary);
            transition: background 0.3s ease, border-color 0.3s ease;
        }

        .card-header {
            background: transparent;
            border-bottom: 1px solid var(--border-color);
            padding: 20px 24px;
        }

        .card-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--text-heading);
            margin: 0;
        }

        .card-body {
            padding: 24px;
        }

        /* Statistics Cards */
        .stat-card {
            background: var(--bg-card);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 24px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--primary) 0%, var(--primary-light) 100%);
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }

        .stat-info {
            flex: 1;
        }

        .stat-label {
            color: var(--text-secondary);
            font-size: 13px;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 8px;
        }

        .stat-value {
            font-size: 28px;
            font-weight: 700;
            color: var(--text-heading);
            margin-bottom: 8px;
        }

        /* Ensure text visibility in light theme */
        [data-theme="light"] {
            color: var(--text-primary) !important;
        }

        [data-theme="light"] .text-muted,
        [data-theme="light"] .text-secondary {
            color: var(--text-secondary) !important;
        }

        [data-theme="light"] .text-primary,
        [data-theme="light"] .text-heading,
        [data-theme="light"] h1,
        [data-theme="light"] h2,
        [data-theme="light"] h3,
        [data-theme="light"] h4,
        [data-theme="light"] h5,
        [data-theme="light"] h6 {
            color: var(--text-heading) !important;
        }

        [data-theme="light"] span:not(.badge):not(.btn):not(.text-white):not(.text-success):not(.text-danger):not(.text-warning):not(.text-info):not(.text-primary) {
            color: var(--text-primary) !important;
        }

        [data-theme="light"] p:not(.text-white):not(.text-success):not(.text-danger):not(.text-warning):not(.text-info):not(.text-primary) {
            color: var(--text-primary) !important;
        }

        [data-theme="light"] td:not(.text-white):not(.text-success):not(.text-danger):not(.text-warning):not(.text-info):not(.text-primary),
        [data-theme="light"] th:not(.text-white):not(.text-success):not(.text-danger):not(.text-warning):not(.text-info):not(.text-primary) {
            color: var(--text-primary) !important;
        }

        [data-theme="light"] .card-body,
        [data-theme="light"] .card-header,
        [data-theme="light"] .stat-label,
        [data-theme="light"] .stat-value,
        [data-theme="light"] .page-title,
        [data-theme="light"] .page-breadcrumb {
            color: var(--text-primary) !important;
        }

        [data-theme="light"] .stat-value,
        [data-theme="light"] .page-title {
            color: var(--text-heading) !important;
        }

        [data-theme="light"] .stat-label,
        [data-theme="light"] .page-breadcrumb {
            color: var(--text-secondary) !important;
        }

        [data-theme="light"] .card-title {
            color: var(--text-heading) !important;
        }

        [data-theme="light"] .user-name {
            color: var(--text-heading) !important;
        }

        [data-theme="light"] .user-role {
            color: var(--text-secondary) !important;
        }

        /* Dashboard Cards Equal Height */
        .dashboard-row {
            display: flex;
            flex-wrap: wrap;
        }

        .dashboard-row > [class*="col-"] {
            display: flex;
            flex-direction: column;
        }

        .dashboard-row .card {
            display: flex;
            flex-direction: column;
            width: 100%;
            height: 100%;
        }

        .dashboard-row .card .card-body {
            flex: 1;
            display: flex;
            flex-direction: column;
        }

        .dashboard-row .card.h-100 {
            min-height: 100%;
        }

        .stat-change {
            font-size: 13px;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            padding: 4px 10px;
            border-radius: 6px;
        }

        .stat-change.positive {
            color: var(--success);
            background: rgba(40, 199, 111, 0.1);
        }

        .stat-change.negative {
            color: var(--danger);
            background: rgba(234, 84, 85, 0.1);
        }

        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
        }

        /* Tables */
        .table {
            color: var(--text-primary);
        }

        .table thead th {
            background: var(--hover-bg);
            border-bottom: 1px solid var(--border-color);
            color: var(--text-primary);
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            padding: 15px;
        }

        .table tbody tr {
            border-bottom: 1px solid var(--border-color);
            transition: background 0.2s ease;
        }

        .table tbody tr:hover {
            background: var(--hover-bg);
        }

        .table tbody td {
            padding: 15px;
            vertical-align: middle;
        }

        /* Buttons */
        .btn-primary {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            border: none;
            padding: 10px 24px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(115, 103, 240, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(115, 103, 240, 0.4);
        }

        .btn-success {
            background: linear-gradient(135deg, var(--success) 0%, #22c55e 100%);
            border: none;
            box-shadow: 0 4px 12px rgba(40, 199, 111, 0.3);
        }

        .btn-danger {
            background: linear-gradient(135deg, var(--danger) 0%, #dc2626 100%);
            border: none;
            box-shadow: 0 4px 12px rgba(234, 84, 85, 0.3);
        }

        .btn-warning {
            background: linear-gradient(135deg, var(--warning) 0%, #f97316 100%);
            border: none;
            box-shadow: 0 4px 12px rgba(255, 159, 67, 0.3);
        }

        /* Badges */
        .badge {
            padding: 6px 12px;
            border-radius: 6px;
            font-weight: 600;
            font-size: 12px;
        }

        /* Forms */
        .form-control, .form-select {
            background: var(--hover-bg);
            border: 1px solid var(--border-light);
            color: var(--text-heading);
            padding: 10px 15px;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .form-control:focus, .form-select:focus {
            background: var(--hover-bg-light);
            border-color: var(--primary);
            color: var(--text-heading);
            box-shadow: 0 0 0 3px rgba(115, 103, 240, 0.1);
        }

        .form-label {
            color: var(--text-primary);
            font-weight: 500;
            margin-bottom: 8px;
        }

        /* Alerts */
        .alert {
            border: none;
            border-radius: 8px;
            padding: 15px 20px;
        }

        .alert-success {
            background: rgba(40, 199, 111, 0.1);
            color: var(--success);
            border-left: 3px solid var(--success);
        }

        .alert-danger {
            background: rgba(234, 84, 85, 0.1);
            color: var(--danger);
            border-left: 3px solid var(--danger);
        }

        /* Mobile Responsive */
        @media (max-width: 992px) {
            .sidebar {
                transform: translateX(-100%);
                z-index: 1001;
            }

            .sidebar.active {
                transform: translateX(0);
                box-shadow: 2px 0 20px rgba(0,0,0,0.3);
            }

            .main-content {
                margin-left: 0;
                width: 100%;
            }

            .navbar-custom {
                left: 0;
            }

            .mobile-menu-toggle {
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .search-box {
                width: 200px;
            }

            .page-content {
                padding: 20px 15px;
            }

            .stat-value {
                font-size: 22px;
            }

            .stat-icon {
                width: 50px;
                height: 50px;
                font-size: 24px;
            }
        }

        @media (max-width: 576px) {
            .search-box {
                display: none;
            }

            .user-info {
                display: none;
            }
        }

        /* Dropdown */
        .dropdown-menu {
            background: var(--bg-card);
            border: 1px solid var(--border-light);
            border-radius: 8px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.3);
            padding: 8px;
            transition: background 0.3s ease;
        }

        .dropdown-item {
            color: var(--text-primary);
            padding: 10px 15px;
            border-radius: 6px;
            transition: all 0.2s ease;
        }

        .dropdown-item:hover {
            background: var(--hover-bg);
            color: var(--text-heading);
        }

        .dropdown-divider {
            border-color: var(--border-color);
        }
    </style>
    <?php echo $__env->yieldContent('styles'); ?>
</head>
<body data-theme="<?php echo e(auth()->user()->theme_preference ?? 'dark'); ?>">
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <i class="bi bi-currency-dollar"></i>
            </div>
            <div class="sidebar-brand">MicroLoan</div>
        </div>
        
        <div class="sidebar-menu">
            <?php if(auth()->user()->role === 'admin'): ?>
                <div class="menu-section-title">Main Menu</div>
                <div class="menu-item">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="menu-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-speedometer2"></i></span>
                        <span class="menu-text">Dashboard</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Management</div>
                <div class="menu-item">
                    <a href="<?php echo e(route('admin.partners.index')); ?>" class="menu-link <?php echo e(request()->routeIs('admin.partners.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-people"></i></span>
                        <span class="menu-text">Partners</span>
                    </a>
                </div>
                <div class="menu-item">
                    <a href="<?php echo e(route('admin.subscriptions.index')); ?>" class="menu-link <?php echo e(request()->routeIs('admin.subscriptions.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-credit-card"></i></span>
                        <span class="menu-text">Subscriptions</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Settings</div>
                <div class="menu-item">
                    <a href="<?php echo e(route('admin.razorpay-settings.index')); ?>" class="menu-link <?php echo e(request()->routeIs('admin.razorpay-settings.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-gear"></i></span>
                        <span class="menu-text">Razorpay Settings</span>
                    </a>
                </div>
            <?php else: ?>
                <div class="menu-section-title">Main Menu</div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.dashboard')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.dashboard') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-speedometer2"></i></span>
                        <span class="menu-text">Dashboard</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Customers</div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.customers.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.customers.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-person-badge"></i></span>
                        <span class="menu-text">Customers</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Loans & Savings</div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.loans.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.loans.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-wallet2"></i></span>
                        <span class="menu-text">Loans</span>
                    </a>
                </div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.savings.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.savings.*') && !request()->routeIs('partner.savings-collections.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-piggy-bank"></i></span>
                        <span class="menu-text">Savings</span>
                    </a>
                </div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.savings-collections.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.savings-collections.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-cash-coin"></i></span>
                        <span class="menu-text">Savings Collections</span>
                    </a>
                </div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.repayments.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.repayments.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-cash-coin"></i></span>
                        <span class="menu-text">Repayments</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Reports</div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.reports.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.reports.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-file-earmark-bar-graph"></i></span>
                        <span class="menu-text">Reports</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Subscription</div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.subscription.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.subscription.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-credit-card"></i></span>
                        <span class="menu-text">Subscription</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Configuration</div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.loan-schemes.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.loan-schemes.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-wallet2"></i></span>
                        <span class="menu-text">Loan Schemes</span>
                    </a>
                </div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.savings-schemes.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.savings-schemes.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-piggy-bank"></i></span>
                        <span class="menu-text">Savings Schemes</span>
                    </a>
                </div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.penalties.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.penalties.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-exclamation-triangle"></i></span>
                        <span class="menu-text">Penalties</span>
                    </a>
                </div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.settings.index')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.settings.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-gear"></i></span>
                        <span class="menu-text">Number Format Settings</span>
                    </a>
                </div>
                
                <div class="menu-section-title">Account</div>
                <div class="menu-item">
                    <a href="<?php echo e(route('partner.profile.show')); ?>" class="menu-link <?php echo e(request()->routeIs('partner.profile.*') ? 'active' : ''); ?>">
                        <span class="menu-icon"><i class="bi bi-person-circle"></i></span>
                        <span class="menu-text">My Profile</span>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Navbar -->
        <nav class="navbar-custom">
            <div class="navbar-left">
                <button class="mobile-menu-toggle" id="mobileMenuToggle">
                    <i class="bi bi-list"></i>
                </button>
                <div class="search-box">
                    <i class="bi bi-search search-icon"></i>
                    <input type="text" placeholder="Search...">
                </div>
            </div>
            
            <div class="navbar-right">
                <?php if(auth()->user()->role === 'partner' && auth()->user()->partner): ?>
                    <?php
                        $activeSubscription = auth()->user()->partner->activeSubscription();
                    ?>
                    <?php if(!$activeSubscription): ?>
                        <a href="<?php echo e(route('partner.subscription.index')); ?>" class="btn btn-danger btn-sm me-2" style="white-space: nowrap;">
                            <i class="bi bi-exclamation-triangle-fill me-1"></i>No Subscription
                        </a>
                    <?php elseif($activeSubscription->end_date && $activeSubscription->end_date->diffInDays(now()) <= 7): ?>
                        <a href="<?php echo e(route('partner.subscription.index')); ?>" class="btn btn-warning btn-sm me-2" style="white-space: nowrap;">
                            <i class="bi bi-clock me-1"></i>Expires in <?php echo e($activeSubscription->end_date->diffInDays(now())); ?> days
                        </a>
                    <?php endif; ?>
                <?php endif; ?>
                
                <button class="theme-toggle-btn" id="themeToggle" title="Toggle Theme">
                    <i class="bi bi-<?php echo e(auth()->user()->theme_preference === 'light' ? 'moon' : 'sun'); ?>"></i>
                </button>
                
                <button class="nav-icon-btn">
                    <i class="bi bi-bell"></i>
                    <span class="badge">5</span>
                </button>
                <button class="nav-icon-btn">
                    <i class="bi bi-cart"></i>
                    <span class="badge">3</span>
                </button>
                
                <div class="dropdown">
                    <div class="user-dropdown" data-bs-toggle="dropdown">
                        <div class="user-avatar">
                            <?php echo e(substr(auth()->user()->name, 0, 1)); ?>

                        </div>
                        <div class="user-info">
                            <div class="user-name"><?php echo e(auth()->user()->name); ?></div>
                            <div class="user-role"><?php echo e(ucfirst(auth()->user()->role)); ?></div>
                        </div>
                        <i class="bi bi-chevron-down"></i>
                    </div>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <?php if(auth()->user()->role === 'partner'): ?>
                        <li><a class="dropdown-item" href="<?php echo e(route('partner.profile.show')); ?>">
                            <i class="bi bi-person me-2"></i> My Profile
                        </a></li>
                        <li><hr class="dropdown-divider"></li>
                        <?php endif; ?>
                        <li>
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="dropdown-item">
                                    <i class="bi bi-box-arrow-right me-2"></i> Logout
                                </button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>

        <!-- Page Content -->
        <div class="page-content">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle me-2"></i>
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-x-circle me-2"></i>
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Mobile menu toggle
        document.getElementById('mobileMenuToggle')?.addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('active');
        });

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const toggle = document.getElementById('mobileMenuToggle');
            
            if (window.innerWidth <= 992) {
                if (!sidebar.contains(event.target) && event.target !== toggle) {
                    sidebar.classList.remove('active');
                }
            }
        });

        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);

        // Theme Toggle
        document.getElementById('themeToggle')?.addEventListener('click', function() {
            const currentTheme = document.body.getAttribute('data-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            const icon = this.querySelector('i');
            
            // Update theme immediately for smooth transition
            document.body.setAttribute('data-theme', newTheme);
            
            // Update icon
            icon.className = newTheme === 'light' ? 'bi bi-moon' : 'bi bi-sun';
            
            // Save to server
            fetch('<?php echo e(route("theme.toggle")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({})
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    console.log('Theme updated to:', data.theme);
                }
            })
            .catch(error => {
                console.error('Error updating theme:', error);
                // Revert on error
                document.body.setAttribute('data-theme', currentTheme);
                icon.className = currentTheme === 'light' ? 'bi bi-moon' : 'bi bi-sun';
            });
        });
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\micro-master\resources\views/layouts/app.blade.php ENDPATH**/ ?>