

<?php $__env->startSection('title', 'Savings Report'); ?>
<?php $__env->startSection('page-title', 'Savings Report'); ?>

<?php $__env->startSection('content'); ?>
<style>
    @media print {
        .no-print { display: none !important; }
        .card { border: none !important; box-shadow: none !important; }
    }
</style>

<div class="card no-print mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('partner.reports.savings')); ?>" class="row g-3">
            <div class="col-md-2">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>">
            </div>
            <div class="col-md-2">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>">
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="matured" <?php echo e(request('status') === 'matured' ? 'selected' : ''); ?>>Matured</option>
                    <option value="closed" <?php echo e(request('status') === 'closed' ? 'selected' : ''); ?>>Closed</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Type</label>
                <select name="type" class="form-select">
                    <option value="">All Types</option>
                    <option value="deposit" <?php echo e(request('type') === 'deposit' ? 'selected' : ''); ?>>Deposit</option>
                    <option value="withdrawal" <?php echo e(request('type') === 'withdrawal' ? 'selected' : ''); ?>>Withdrawal</option>
                </select>
            </div>
            <div class="col-md-4 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="<?php echo e(route('partner.reports.savings')); ?>" class="btn btn-secondary">Reset</a>
                <button type="button" onclick="window.print()" class="btn btn-info">
                    <i class="bi bi-printer me-2"></i>Print
                </button>
            </div>
        </form>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Accounts</h6>
                <h3 style="color: var(--text-heading);"><?php echo e($summary['total_accounts']); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Deposits</h6>
                <h3 style="color: var(--success);">₹<?php echo e(number_format($summary['total_deposits'], 2)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Withdrawals</h6>
                <h3 style="color: var(--danger);">₹<?php echo e(number_format($summary['total_withdrawals'], 2)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Balance</h6>
                <h3 style="color: var(--text-heading);">₹<?php echo e(number_format($summary['total_balance'], 2)); ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Savings Details</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Savings #</th>
                        <th>Customer</th>
                        <th>Scheme</th>
                        <th>Type</th>
                        <th class="text-end">Amount</th>
                        <th>Deposit Date</th>
                        <th>Maturity Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $savings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $saving): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($saving->savings_number); ?></td>
                        <td><?php echo e($saving->customer->name); ?></td>
                        <td><?php echo e($saving->scheme->name ?? 'N/A'); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($saving->type === 'deposit' ? 'success' : 'warning'); ?>">
                                <?php echo e(ucfirst($saving->type)); ?>

                            </span>
                        </td>
                        <td class="text-end <?php echo e($saving->type === 'withdrawal' ? 'text-danger' : 'text-success'); ?>">
                            <?php echo e($saving->type === 'withdrawal' ? '-' : '+'); ?>₹<?php echo e(number_format($saving->amount, 2)); ?>

                        </td>
                        <td><?php echo e($saving->deposit_date->format('d M Y')); ?></td>
                        <td><?php echo e($saving->maturity_date ? $saving->maturity_date->format('d M Y') : 'N/A'); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($saving->status === 'active' ? 'success' : ($saving->status === 'matured' ? 'info' : 'secondary')); ?>">
                                <?php echo e(ucfirst($saving->status)); ?>

                            </span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No savings found</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
                <?php if($savings->count() > 0): ?>
                <tfoot>
                    <tr class="table-info">
                        <td colspan="4" class="text-end"><strong>Total:</strong></td>
                        <td class="text-end">
                            <strong>₹<?php echo e(number_format($summary['total_deposits'] - $summary['total_withdrawals'], 2)); ?></strong>
                        </td>
                        <td colspan="3"></td>
                    </tr>
                </tfoot>
                <?php endif; ?>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\micro-master\resources\views/partner/reports/savings.blade.php ENDPATH**/ ?>