<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

// Partner Mobile API Routes
Route::prefix('partner')->group(function () {
    // Public routes
    Route::post('/login', [App\Http\Controllers\Api\PartnerApiController::class, 'login']);
    
    // Protected routes
    Route::middleware('auth:sanctum')->group(function () {
        Route::post('/logout', [App\Http\Controllers\Api\PartnerApiController::class, 'logout']);
        Route::get('/dashboard', [App\Http\Controllers\Api\PartnerApiController::class, 'dashboard']);
        Route::get('/dashboard/summary', [App\Http\Controllers\Api\PartnerApiController::class, 'dashboardSummary']);
        Route::get('/loans', [App\Http\Controllers\Api\PartnerApiController::class, 'loans']);
        Route::get('/savings', [App\Http\Controllers\Api\PartnerApiController::class, 'savings']);
        Route::get('/customers', [App\Http\Controllers\Api\PartnerApiController::class, 'customers']);
        Route::get('/schemes', [App\Http\Controllers\Api\PartnerApiController::class, 'schemes']);
        Route::get('/profile', [App\Http\Controllers\Api\PartnerApiController::class, 'profile']);
    });
});

