@extends('layouts.app')

@section('title', 'Number Format Settings')
@section('page-title', 'Number Format Settings')

@section('content')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Configure Number Formats</h5>
                <p class="text-muted mb-0 small">Customize how customer IDs, loan numbers, and savings numbers are generated</p>
            </div>
            <div class="card-body">
                <form action="{{ route('partner.settings.update') }}" method="POST">
                    @csrf
                    @method('PUT')

                    <!-- Customer ID/Account Number Settings -->
                    <div class="mb-5">
                        <h5 class="mb-3" style="color: var(--text-heading);">
                            <i class="bi bi-person-badge me-2"></i>Customer ID / Account Number
                        </h5>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Prefix <small class="text-muted">(Optional)</small></label>
                                <input type="text" 
                                       class="form-control" 
                                       name="customer_prefix" 
                                       value="{{ old('customer_prefix', $partner->customer_prefix) }}"
                                       placeholder="e.g., CUST-"
                                       maxlength="20">
                                <small class="text-muted">Text before the number</small>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Suffix <small class="text-muted">(Optional)</small></label>
                                <input type="text" 
                                       class="form-control" 
                                       name="customer_suffix" 
                                       value="{{ old('customer_suffix', $partner->customer_suffix) }}"
                                       placeholder="e.g., -ACC"
                                       maxlength="20">
                                <small class="text-muted">Text after the number</small>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Number Type <span class="text-danger">*</span></label>
                                <select class="form-select" name="customer_number_type" id="customer_number_type">
                                    <option value="sequential" {{ old('customer_number_type', $partner->customer_number_type ?? 'sequential') === 'sequential' ? 'selected' : '' }}>
                                        Sequential (SL Wise)
                                    </option>
                                    <option value="random" {{ old('customer_number_type', $partner->customer_number_type) === 'random' ? 'selected' : '' }}>
                                        Random (5 digits)
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3" id="customer_last_number_field" style="display: {{ old('customer_number_type', $partner->customer_number_type ?? 'sequential') === 'sequential' ? 'block' : 'none' }};">
                                <label class="form-label">Last Number <small class="text-muted">(For Sequential)</small></label>
                                <input type="number" 
                                       class="form-control" 
                                       name="customer_last_number" 
                                       value="{{ old('customer_last_number', $partner->customer_last_number ?? 0) }}"
                                       min="0">
                                <small class="text-muted">Next number will be: {{ ($partner->customer_last_number ?? 0) + 1 }}</small>
                            </div>
                        </div>
                        <div class="alert alert-info mt-3">
                            <strong>Preview:</strong> 
                            <code id="customer_preview">
                                @if($partner->customer_number_type === 'random')
                                    {{ ($partner->customer_prefix ?? '') . '12345' . ($partner->customer_suffix ?? '') }}
                                @else
                                    {{ ($partner->customer_prefix ?? '') . str_pad(($partner->customer_last_number ?? 0) + 1, 5, '0', STR_PAD_LEFT) . ($partner->customer_suffix ?? '') }}
                                @endif
                            </code>
                        </div>
                    </div>

                    <hr style="border-color: var(--border-color);">

                    <!-- Loan Number Settings -->
                    <div class="mb-5">
                        <h5 class="mb-3" style="color: var(--text-heading);">
                            <i class="bi bi-wallet2 me-2"></i>Loan Number
                        </h5>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Prefix <small class="text-muted">(Optional)</small></label>
                                <input type="text" 
                                       class="form-control" 
                                       name="loan_prefix" 
                                       value="{{ old('loan_prefix', $partner->loan_prefix) }}"
                                       placeholder="e.g., LOAN-"
                                       maxlength="20">
                                <small class="text-muted">Text before the number</small>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Suffix <small class="text-muted">(Optional)</small></label>
                                <input type="text" 
                                       class="form-control" 
                                       name="loan_suffix" 
                                       value="{{ old('loan_suffix', $partner->loan_suffix) }}"
                                       placeholder="e.g., -2024"
                                       maxlength="20">
                                <small class="text-muted">Text after the number</small>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Number Type <span class="text-danger">*</span></label>
                                <select class="form-select" name="loan_number_type" id="loan_number_type">
                                    <option value="sequential" {{ old('loan_number_type', $partner->loan_number_type ?? 'sequential') === 'sequential' ? 'selected' : '' }}>
                                        Sequential (SL Wise)
                                    </option>
                                    <option value="random" {{ old('loan_number_type', $partner->loan_number_type) === 'random' ? 'selected' : '' }}>
                                        Random (5 digits)
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3" id="loan_last_number_field" style="display: {{ old('loan_number_type', $partner->loan_number_type ?? 'sequential') === 'sequential' ? 'block' : 'none' }};">
                                <label class="form-label">Last Number <small class="text-muted">(For Sequential)</small></label>
                                <input type="number" 
                                       class="form-control" 
                                       name="loan_last_number" 
                                       value="{{ old('loan_last_number', $partner->loan_last_number ?? 0) }}"
                                       min="0">
                                <small class="text-muted">Next number will be: {{ ($partner->loan_last_number ?? 0) + 1 }}</small>
                            </div>
                        </div>
                        <div class="alert alert-info mt-3">
                            <strong>Preview:</strong> 
                            <code id="loan_preview">
                                @if($partner->loan_number_type === 'random')
                                    {{ ($partner->loan_prefix ?? '') . '12345' . ($partner->loan_suffix ?? '') }}
                                @else
                                    {{ ($partner->loan_prefix ?? '') . str_pad(($partner->loan_last_number ?? 0) + 1, 5, '0', STR_PAD_LEFT) . ($partner->loan_suffix ?? '') }}
                                @endif
                            </code>
                        </div>
                    </div>

                    <hr style="border-color: var(--border-color);">

                    <!-- Savings Number Settings -->
                    <div class="mb-4">
                        <h5 class="mb-3" style="color: var(--text-heading);">
                            <i class="bi bi-piggy-bank me-2"></i>Savings Number
                        </h5>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Prefix <small class="text-muted">(Optional)</small></label>
                                <input type="text" 
                                       class="form-control" 
                                       name="savings_prefix" 
                                       value="{{ old('savings_prefix', $partner->savings_prefix) }}"
                                       placeholder="e.g., SAV-"
                                       maxlength="20">
                                <small class="text-muted">Text before the number</small>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Suffix <small class="text-muted">(Optional)</small></label>
                                <input type="text" 
                                       class="form-control" 
                                       name="savings_suffix" 
                                       value="{{ old('savings_suffix', $partner->savings_suffix) }}"
                                       placeholder="e.g., -SAV"
                                       maxlength="20">
                                <small class="text-muted">Text after the number</small>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Number Type <span class="text-danger">*</span></label>
                                <select class="form-select" name="savings_number_type" id="savings_number_type">
                                    <option value="sequential" {{ old('savings_number_type', $partner->savings_number_type ?? 'sequential') === 'sequential' ? 'selected' : '' }}>
                                        Sequential (SL Wise)
                                    </option>
                                    <option value="random" {{ old('savings_number_type', $partner->savings_number_type) === 'random' ? 'selected' : '' }}>
                                        Random (5 digits)
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3" id="savings_last_number_field" style="display: {{ old('savings_number_type', $partner->savings_number_type ?? 'sequential') === 'sequential' ? 'block' : 'none' }};">
                                <label class="form-label">Last Number <small class="text-muted">(For Sequential)</small></label>
                                <input type="number" 
                                       class="form-control" 
                                       name="savings_last_number" 
                                       value="{{ old('savings_last_number', $partner->savings_last_number ?? 0) }}"
                                       min="0">
                                <small class="text-muted">Next number will be: {{ ($partner->savings_last_number ?? 0) + 1 }}</small>
                            </div>
                        </div>
                        <div class="alert alert-info mt-3">
                            <strong>Preview:</strong> 
                            <code id="savings_preview">
                                @if($partner->savings_number_type === 'random')
                                    {{ ($partner->savings_prefix ?? '') . '12345' . ($partner->savings_suffix ?? '') }}
                                @else
                                    {{ ($partner->savings_prefix ?? '') . str_pad(($partner->savings_last_number ?? 0) + 1, 5, '0', STR_PAD_LEFT) . ($partner->savings_suffix ?? '') }}
                                @endif
                            </code>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('partner.dashboard') }}" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Save Settings
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    // Customer Number Type Toggle
    document.getElementById('customer_number_type')?.addEventListener('change', function() {
        const lastNumberField = document.getElementById('customer_last_number_field');
        if (this.value === 'sequential') {
            lastNumberField.style.display = 'block';
        } else {
            lastNumberField.style.display = 'none';
        }
        updateCustomerPreview();
    });

    // Loan Number Type Toggle
    document.getElementById('loan_number_type')?.addEventListener('change', function() {
        const lastNumberField = document.getElementById('loan_last_number_field');
        if (this.value === 'sequential') {
            lastNumberField.style.display = 'block';
        } else {
            lastNumberField.style.display = 'none';
        }
        updateLoanPreview();
    });

    // Savings Number Type Toggle
    document.getElementById('savings_number_type')?.addEventListener('change', function() {
        const lastNumberField = document.getElementById('savings_last_number_field');
        if (this.value === 'sequential') {
            lastNumberField.style.display = 'block';
        } else {
            lastNumberField.style.display = 'none';
        }
        updateSavingsPreview();
    });

    // Update Previews
    function updateCustomerPreview() {
        const prefix = document.querySelector('input[name="customer_prefix"]').value || '';
        const suffix = document.querySelector('input[name="customer_suffix"]').value || '';
        const type = document.getElementById('customer_number_type').value;
        const lastNumber = parseInt(document.querySelector('input[name="customer_last_number"]').value) || 0;
        
        let number = type === 'random' ? '12345' : String(lastNumber + 1).padStart(5, '0');
        document.getElementById('customer_preview').textContent = prefix + number + suffix;
    }

    function updateLoanPreview() {
        const prefix = document.querySelector('input[name="loan_prefix"]').value || '';
        const suffix = document.querySelector('input[name="loan_suffix"]').value || '';
        const type = document.getElementById('loan_number_type').value;
        const lastNumber = parseInt(document.querySelector('input[name="loan_last_number"]').value) || 0;
        
        let number = type === 'random' ? '12345' : String(lastNumber + 1).padStart(5, '0');
        document.getElementById('loan_preview').textContent = prefix + number + suffix;
    }

    function updateSavingsPreview() {
        const prefix = document.querySelector('input[name="savings_prefix"]').value || '';
        const suffix = document.querySelector('input[name="savings_suffix"]').value || '';
        const type = document.getElementById('savings_number_type').value;
        const lastNumber = parseInt(document.querySelector('input[name="savings_last_number"]').value) || 0;
        
        let number = type === 'random' ? '12345' : String(lastNumber + 1).padStart(5, '0');
        document.getElementById('savings_preview').textContent = prefix + number + suffix;
    }

    // Add event listeners for input changes
    document.querySelectorAll('input[name="customer_prefix"], input[name="customer_suffix"], input[name="customer_last_number"]').forEach(input => {
        input.addEventListener('input', updateCustomerPreview);
    });

    document.querySelectorAll('input[name="loan_prefix"], input[name="loan_suffix"], input[name="loan_last_number"]').forEach(input => {
        input.addEventListener('input', updateLoanPreview);
    });

    document.querySelectorAll('input[name="savings_prefix"], input[name="savings_suffix"], input[name="savings_last_number"]').forEach(input => {
        input.addEventListener('input', updateSavingsPreview);
    });
</script>
@endsection



