@extends('layouts.app')

@section('title', 'Scheme Details')
@section('page-title', 'Scheme Details')

@section('content')
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Scheme Information</h5>
        <div>
            <a href="{{ route('partner.schemes.edit', $scheme) }}" class="btn btn-warning btn-sm">
                <i class="bi bi-pencil"></i> Edit
            </a>
            <a href="{{ route('partner.schemes.index') }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>Name:</strong> {{ $scheme->name }}</p>
                <p><strong>Type:</strong> <span class="badge bg-info">{{ ucfirst($scheme->type) }}</span></p>
                <p><strong>Interest Type:</strong> {{ ucfirst($scheme->interest_type ?? 'percentage') }}</p>
                <p><strong>Interest Rate:</strong> {{ $scheme->interest_rate }}{{ $scheme->interest_type === 'flat' ? ' (Flat)' : '%' }}</p>
                <p><strong>Duration:</strong> 
                    @if($scheme->duration_type && $scheme->duration_value)
                        {{ $scheme->duration_value }} {{ ucfirst($scheme->duration_type) }}
                    @else
                        {{ $scheme->duration_months ?? 'N/A' }} months
                    @endif
                </p>
            </div>
            <div class="col-md-6">
                <p><strong>Min Amount:</strong> ₹{{ number_format($scheme->min_amount, 2) }}</p>
                <p><strong>Max Amount:</strong> ₹{{ number_format($scheme->max_amount ?? 0, 2) }}</p>
                <p><strong>Processing Fee:</strong> ₹{{ number_format($scheme->processing_fee ?? 0, 2) }}</p>
                <p><strong>Insurance Fee:</strong> ₹{{ number_format($scheme->insurance_fee ?? 0, 2) }}</p>
                <p><strong>Other Fee:</strong> ₹{{ number_format($scheme->other_fee ?? 0, 2) }}</p>
                <p><strong>Late Fee:</strong> 
                    @if($scheme->late_fee_type && $scheme->late_fee_value)
                        {{ $scheme->late_fee_value }} 
                        {{ $scheme->late_fee_type === 'percentage' ? '% per day' : '₹ per day' }}
                    @else
                        <span class="text-muted">Not configured</span>
                    @endif
                </p>
                <p><strong>Status:</strong> 
                    <span class="badge bg-{{ $scheme->status === 'active' ? 'success' : 'secondary' }}">
                        {{ ucfirst($scheme->status) }}
                    </span>
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

