@extends('layouts.app')

@section('title', 'Savings Statement')
@section('page-title', 'Savings Statement')

@section('content')
<style>
    @media print {
        .no-print {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        body {
            background: white !important;
        }
    }
    .statement-header {
        border-bottom: 3px solid #6366f1;
        padding-bottom: 1rem;
        margin-bottom: 2rem;
    }
    .statement-section {
        margin-bottom: 2rem;
    }
    .statement-table {
        font-size: 0.9rem;
    }
    .statement-table th {
        background: #f8f9fa;
        font-weight: 600;
    }
    .total-row {
        font-weight: 700;
        background: #f8f9fa;
    }
</style>

<div class="card no-print mb-3">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Savings Statement</h5>
            <div class="d-flex gap-2">
                <button onclick="window.print()" class="btn btn-primary btn-sm">
                    <i class="bi bi-printer"></i> Print
                </button>
                <a href="{{ route('partner.customers.show', $customer) }}" class="btn btn-secondary btn-sm">
                    <i class="bi bi-arrow-left"></i> Back
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <!-- Statement Header -->
        <div class="statement-header text-center">
            <h2 class="mb-2">MicroLoan Management System</h2>
            <h4 class="text-primary mb-1">Savings Account Statement</h4>
            <p class="text-muted mb-0">Generated on: {{ now()->format('d M Y, h:i A') }}</p>
        </div>

        <!-- Customer Information -->
        <div class="statement-section">
            <h5 class="mb-3">Customer Information</h5>
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Customer Name:</strong></td>
                            <td>{{ $customer->name }}</td>
                        </tr>
                        <tr>
                            <td><strong>Customer Code:</strong></td>
                            <td>{{ $customer->customer_code }}</td>
                        </tr>
                        <tr>
                            <td><strong>Phone:</strong></td>
                            <td>{{ $customer->phone }}</td>
                        </tr>
                        <tr>
                            <td><strong>Email:</strong></td>
                            <td>{{ $customer->email ?? 'N/A' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Address:</strong></td>
                            <td>{{ $customer->address ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td>
                                <span class="badge bg-{{ $customer->status === 'active' ? 'success' : 'secondary' }}">
                                    {{ ucfirst($customer->status) }}
                                </span>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Account Summary -->
        <div class="statement-section">
            <h5 class="mb-3">Account Summary</h5>
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="card bg-success bg-opacity-10">
                        <div class="card-body text-center">
                            <h6 class="text-muted mb-1">Total Deposits</h6>
                            <h4 class="mb-0 text-success">₹{{ number_format($totalDeposits, 2) }}</h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card bg-warning bg-opacity-10">
                        <div class="card-body text-center">
                            <h6 class="text-muted mb-1">Total Withdrawals</h6>
                            <h4 class="mb-0 text-warning">₹{{ number_format($totalWithdrawals, 2) }}</h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card bg-primary bg-opacity-10">
                        <div class="card-body text-center">
                            <h6 class="text-muted mb-1">Current Balance</h6>
                            <h4 class="mb-0 text-primary">₹{{ number_format($balance, 2) }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Transaction Details -->
        <div class="statement-section">
            <h5 class="mb-3">Transaction History</h5>
            <div class="table-responsive">
                <table class="table table-bordered statement-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Transaction #</th>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Scheme</th>
                            <th class="text-end">Amount</th>
                            <th>Interest Rate</th>
                            <th>Duration</th>
                            <th>Maturity Date</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($savings as $index => $saving)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $saving->savings_number }}</td>
                            <td>{{ $saving->deposit_date->format('d M Y') }}</td>
                            <td>
                                <span class="badge bg-{{ $saving->type === 'deposit' ? 'success' : 'warning' }}">
                                    {{ ucfirst($saving->type) }}
                                </span>
                            </td>
                            <td>{{ $saving->scheme ? $saving->scheme->name : 'N/A' }}</td>
                            <td class="text-end {{ $saving->type === 'deposit' ? 'text-success' : 'text-danger' }}">
                                {{ $saving->type === 'deposit' ? '+' : '-' }}₹{{ number_format($saving->amount, 2) }}
                            </td>
                            <td>{{ $saving->interest_rate }}%</td>
                            <td>{{ $saving->duration_value }} {{ ucfirst($saving->duration_type) }}</td>
                            <td>{{ $saving->maturity_date ? $saving->maturity_date->format('d M Y') : 'N/A' }}</td>
                            <td>
                                <span class="badge bg-{{ $saving->status === 'active' ? 'success' : ($saving->status === 'matured' ? 'info' : 'secondary') }}">
                                    {{ ucfirst($saving->status) }}
                                </span>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10" class="text-center py-4">
                                <i class="bi bi-inbox text-muted" style="font-size: 2rem;"></i>
                                <p class="text-muted mb-0 mt-2">No savings transactions found.</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                    @if($savings->count() > 0)
                    <tfoot>
                        <tr class="total-row">
                            <td colspan="5" class="text-end"><strong>Total:</strong></td>
                            <td class="text-end">
                                <strong>
                                    ₹{{ number_format($totalDeposits - $totalWithdrawals, 2) }}
                                </strong>
                            </td>
                            <td colspan="4"></td>
                        </tr>
                    </tfoot>
                    @endif
                </table>
            </div>
        </div>

        <!-- Footer -->
        <div class="statement-section mt-4 pt-3 border-top">
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-0"><strong>Total Transactions:</strong> {{ $savings->count() }}</p>
                </div>
                <div class="col-md-6 text-end">
                    <p class="mb-0 text-muted"><small>This is a computer-generated statement.</small></p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection



