@extends('layouts.app')

@section('title', 'Savings Details')
@section('page-title', 'Savings Details')

@section('content')
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Savings Information</h5>
        <a href="{{ route('partner.savings.index') }}" class="btn btn-secondary btn-sm">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>Savings Number:</strong> {{ $saving->savings_number }}</p>
                <p><strong>Customer:</strong> {{ $saving->customer->name }}</p>
                @if($saving->target_amount)
                <p><strong>Target Amount:</strong> <strong class="text-primary">₹{{ number_format($saving->target_amount, 2) }}</strong></p>
                <p><strong>Collected Amount:</strong> ₹{{ number_format($saving->collected_amount ?? 0, 2) }}</p>
                <p><strong>Remaining Amount:</strong> <strong class="text-danger">₹{{ number_format($saving->remaining_amount, 2) }}</strong></p>
                <p><strong>Installment Amount:</strong> ₹{{ number_format($saving->installment_amount, 2) }}</p>
                @else
                <p><strong>Amount:</strong> ₹{{ number_format($saving->amount, 2) }}</p>
                @endif
                @if($saving->scheme)
                <p><strong>Scheme:</strong> {{ $saving->scheme->name }}</p>
                @endif
            </div>
            <div class="col-md-6">
                <p><strong>Interest Rate:</strong> {{ $saving->interest_rate }}%</p>
                <p><strong>Duration:</strong> {{ $saving->duration_value }} {{ ucfirst($saving->duration_type) }}</p>
                <p><strong>Deposit Date:</strong> {{ $saving->deposit_date->format('d M Y') }}</p>
                <p><strong>Maturity Date:</strong> {{ $saving->maturity_date?->format('d M Y') ?? 'N/A' }}</p>
                <p><strong>Status:</strong> 
                    <span class="badge bg-{{ $saving->status === 'active' ? 'success' : ($saving->status === 'matured' ? 'info' : 'secondary') }}">
                        {{ ucfirst($saving->status) }}
                    </span>
                </p>
                @if($saving->target_amount)
                <div class="mt-3">
                    <a href="{{ route('partner.savings-collections.create') }}?saving_id={{ $saving->id }}" class="btn btn-primary btn-sm">
                        <i class="bi bi-cash-coin"></i> Record Collection
                    </a>
                </div>
                @endif
            </div>
        </div>
        @if($saving->notes)
        <div class="mt-3">
            <p><strong>Notes:</strong> {{ $saving->notes }}</p>
        </div>
        @endif
    </div>
</div>
@endsection

