@extends('layouts.app')

@section('title', 'Savings Scheme Details')
@section('page-title', 'Savings Scheme Details')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">{{ $savingsScheme->name }}</h5>
        <div>
            <a href="{{ route('partner.savings-schemes.edit', $savingsScheme) }}" class="btn btn-warning">
                <i class="bi bi-pencil"></i> Edit
            </a>
            <a href="{{ route('partner.savings-schemes.index') }}" class="btn btn-secondary">Back</a>
        </div>
    </div>
    <div class="card-body">
        <div class="row mb-4">
            <div class="col-md-6">
                <h6>Basic Information</h6>
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">Name:</th>
                        <td>{{ $savingsScheme->name }}</td>
                    </tr>
                    <tr>
                        <th>Description:</th>
                        <td>{{ $savingsScheme->description ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>
                            <span class="badge bg-{{ $savingsScheme->status === 'active' ? 'success' : 'secondary' }}">
                                {{ ucfirst($savingsScheme->status) }}
                            </span>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="col-md-6">
                <h6>Interest Details</h6>
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">Interest Type:</th>
                        <td>{{ ucfirst($savingsScheme->interest_type) }}</td>
                    </tr>
                    <tr>
                        <th>Interest Rate:</th>
                        <td>{{ $savingsScheme->interest_rate }}%</td>
                    </tr>
                    <tr>
                        <th>Duration:</th>
                        <td>{{ $savingsScheme->duration_value }} {{ ucfirst($savingsScheme->duration_type) }}</td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <h6>Amount Limits</h6>
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">Min Amount:</th>
                        <td>₹{{ number_format($savingsScheme->min_amount, 2) }}</td>
                    </tr>
                    <tr>
                        <th>Max Amount:</th>
                        <td>₹{{ number_format($savingsScheme->max_amount ?? 0, 2) }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection


