@extends('layouts.app')

@section('title', 'Savings Schemes')
@section('page-title', 'Savings Schemes')

@section('content')
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Savings Schemes</h5>
        <a href="{{ route('partner.savings-schemes.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> New Savings Scheme
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Type</th>
                        <th>Name</th>
                        <th>Interest Rate</th>
                        <th>Duration</th>
                        <th>Details</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($schemes as $scheme)
                    <tr>
                        <td>
                            <span class="badge bg-{{ $scheme->savings_type === 'RD' ? 'primary' : ($scheme->savings_type === 'FD' ? 'success' : 'warning') }} fs-6">
                                {{ $scheme->savings_type ?? 'RD' }}
                            </span>
                        </td>
                        <td>
                            <strong>{{ $scheme->name }}</strong>
                            @if($scheme->description)
                                <br><small class="text-muted">{{ \Illuminate\Support\Str::limit($scheme->description, 50) }}</small>
                            @endif
                        </td>
                        <td>
                            <strong>{{ $scheme->interest_rate }}%</strong>
                            <br>
                            <small class="text-muted">
                                {{ ucfirst($scheme->interest_type ?? 'compound') }}
                                @if(($scheme->interest_type ?? 'compound') === 'compound' && $scheme->savings_type !== 'MIS' && $scheme->compounding_frequency)
                                    | {{ ucfirst($scheme->compounding_frequency) }} Compounding
                                @endif
                            </small>
                        </td>
                        <td>
                            @if($scheme->savings_type === 'RD')
                                <strong>{{ $scheme->duration_value }}</strong> 
                                {{ ucfirst($scheme->duration_type ?? 'monthly') }}
                                @if($scheme->duration_type === 'daily')
                                    <br><small class="text-muted">({{ $scheme->duration_value }} days)</small>
                                @elseif($scheme->duration_type === 'weekly')
                                    <br><small class="text-muted">({{ $scheme->duration_value }} weeks)</small>
                                @endif
                            @else
                                <strong>{{ $scheme->duration_value }}</strong> months
                            @endif
                        </td>
                        <td>
                            @if($scheme->savings_type === 'RD')
                                <div>
                                    <strong>Installment:</strong> ₹{{ number_format($scheme->installment_amount ?? 0, 2) }}
                                    <br>
                                    <small class="text-muted">
                                        @if($scheme->min_amount || $scheme->max_amount)
                                            Range: 
                                            @if($scheme->min_amount)
                                                ₹{{ number_format($scheme->min_amount, 2) }}
                                            @endif
                                            @if($scheme->min_amount && $scheme->max_amount) - @endif
                                            @if($scheme->max_amount)
                                                ₹{{ number_format($scheme->max_amount, 2) }}
                                            @endif
                                        @else
                                            No limits
                                        @endif
                                    </small>
                                </div>
                            @elseif($scheme->savings_type === 'FD')
                                <div>
                                    <strong>Principal Range:</strong>
                                    <br>
                                    <small>
                                        Min: ₹{{ number_format($scheme->min_amount ?? 0, 2) }}
                                        @if($scheme->max_amount)
                                            <br>Max: ₹{{ number_format($scheme->max_amount, 2) }}
                                        @else
                                            <br><span class="text-muted">No max limit</span>
                                        @endif
                                    </small>
                                </div>
                            @elseif($scheme->savings_type === 'MIS')
                                <div>
                                    <strong>Principal Range:</strong>
                                    <br>
                                    <small>
                                        Min: ₹{{ number_format($scheme->min_amount ?? 0, 2) }}
                                        @if($scheme->max_amount)
                                            <br>Max: ₹{{ number_format($scheme->max_amount, 2) }}
                                        @else
                                            <br><span class="text-muted">No max limit</span>
                                        @endif
                                    </small>
                                </div>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $scheme->status === 'active' ? 'success' : 'secondary' }}">
                                {{ ucfirst($scheme->status) }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group">
                                <a href="{{ route('partner.savings-schemes.show', $scheme) }}" class="btn btn-sm btn-info" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="{{ route('partner.savings-schemes.edit', $scheme) }}" class="btn btn-sm btn-warning" title="Edit">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="{{ route('partner.savings-schemes.destroy', $scheme) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this savings scheme?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No savings schemes found</p>
                            <a href="{{ route('partner.savings-schemes.create') }}" class="btn btn-primary mt-3">
                                <i class="bi bi-plus-circle"></i> Create First Savings Scheme
                            </a>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $schemes->links() }}
        </div>
    </div>
</div>

<!-- Filter/Search Section (Optional Enhancement) -->
<div class="card mt-3">
    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <h6 class="mb-3">Scheme Types Summary</h6>
                <div class="d-flex gap-3 flex-wrap">
                    <div>
                        <span class="badge bg-primary">RD</span>
                        <span class="text-muted ms-2">{{ $summary['rd_count'] }} Recurring Deposit{{ $summary['rd_count'] !== 1 ? 's' : '' }}</span>
                    </div>
                    <div>
                        <span class="badge bg-success">FD</span>
                        <span class="text-muted ms-2">{{ $summary['fd_count'] }} Fixed Deposit{{ $summary['fd_count'] !== 1 ? 's' : '' }}</span>
                    </div>
                    <div>
                        <span class="badge bg-warning">MIS</span>
                        <span class="text-muted ms-2">{{ $summary['mis_count'] }} Monthly Income{{ $summary['mis_count'] !== 1 ? 's' : '' }}</span>
                    </div>
                    <div>
                        <span class="badge bg-success">Active</span>
                        <span class="text-muted ms-2">{{ $summary['active_count'] }} Active</span>
                    </div>
                    <div>
                        <span class="badge bg-secondary">Inactive</span>
                        <span class="text-muted ms-2">{{ $summary['inactive_count'] }} Inactive</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
