@extends('layouts.app')

@section('title', 'Collection Details')
@section('page-title', 'Collection Details')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Collection Information</h5>
        <a href="{{ route('partner.savings-collections.index') }}" class="btn btn-secondary btn-sm">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>Collection Number:</strong> {{ $savingsCollection->collection_number }}</p>
                <p><strong>Savings Account:</strong> {{ $savingsCollection->savingsAccount->savings_number }}</p>
                <p><strong>Customer:</strong> {{ $savingsCollection->customer->name }}</p>
                <p><strong>Amount:</strong> ₹{{ number_format($savingsCollection->amount, 2) }}</p>
            </div>
            <div class="col-md-6">
                <p><strong>Collection Date:</strong> {{ $savingsCollection->collection_date->format('d M Y') }}</p>
                @if($savingsCollection->due_date)
                <p><strong>Due Date:</strong> {{ $savingsCollection->due_date->format('d M Y') }}</p>
                @endif
                <p><strong>Payment Method:</strong> <span class="badge bg-info">{{ ucfirst(str_replace('_', ' ', $savingsCollection->payment_method)) }}</span></p>
                @if($savingsCollection->reference_number)
                <p><strong>Reference Number:</strong> {{ $savingsCollection->reference_number }}</p>
                @endif
            </div>
        </div>
        @if($savingsCollection->notes)
        <div class="mt-3">
            <p><strong>Notes:</strong> {{ $savingsCollection->notes }}</p>
        </div>
        @endif
    </div>
</div>
@endsection

