@extends('layouts.app')

@section('title', 'Savings Report')
@section('page-title', 'Savings Report')

@section('content')
<style>
    @media print {
        .no-print { display: none !important; }
        .card { border: none !important; box-shadow: none !important; }
    }
</style>

<div class="card no-print mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('partner.reports.savings') }}" class="row g-3">
            <div class="col-md-2">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                    <option value="matured" {{ request('status') === 'matured' ? 'selected' : '' }}>Matured</option>
                    <option value="closed" {{ request('status') === 'closed' ? 'selected' : '' }}>Closed</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Type</label>
                <select name="type" class="form-select">
                    <option value="">All Types</option>
                    <option value="deposit" {{ request('type') === 'deposit' ? 'selected' : '' }}>Deposit</option>
                    <option value="withdrawal" {{ request('type') === 'withdrawal' ? 'selected' : '' }}>Withdrawal</option>
                </select>
            </div>
            <div class="col-md-4 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="{{ route('partner.reports.savings') }}" class="btn btn-secondary">Reset</a>
                <button type="button" onclick="window.print()" class="btn btn-info">
                    <i class="bi bi-printer me-2"></i>Print
                </button>
            </div>
        </form>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Accounts</h6>
                <h3 style="color: var(--text-heading);">{{ $summary['total_accounts'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Deposits</h6>
                <h3 style="color: var(--success);">₹{{ number_format($summary['total_deposits'], 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Withdrawals</h6>
                <h3 style="color: var(--danger);">₹{{ number_format($summary['total_withdrawals'], 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Balance</h6>
                <h3 style="color: var(--text-heading);">₹{{ number_format($summary['total_balance'], 2) }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Savings Details</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Savings #</th>
                        <th>Customer</th>
                        <th>Scheme</th>
                        <th>Type</th>
                        <th class="text-end">Amount</th>
                        <th>Deposit Date</th>
                        <th>Maturity Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($savings as $saving)
                    <tr>
                        <td>{{ $saving->savings_number }}</td>
                        <td>{{ $saving->customer->name }}</td>
                        <td>{{ $saving->scheme->name ?? 'N/A' }}</td>
                        <td>
                            <span class="badge bg-{{ $saving->type === 'deposit' ? 'success' : 'warning' }}">
                                {{ ucfirst($saving->type) }}
                            </span>
                        </td>
                        <td class="text-end {{ $saving->type === 'withdrawal' ? 'text-danger' : 'text-success' }}">
                            {{ $saving->type === 'withdrawal' ? '-' : '+' }}₹{{ number_format($saving->amount, 2) }}
                        </td>
                        <td>{{ $saving->deposit_date->format('d M Y') }}</td>
                        <td>{{ $saving->maturity_date ? $saving->maturity_date->format('d M Y') : 'N/A' }}</td>
                        <td>
                            <span class="badge bg-{{ $saving->status === 'active' ? 'success' : ($saving->status === 'matured' ? 'info' : 'secondary') }}">
                                {{ ucfirst($saving->status) }}
                            </span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No savings found</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
                @if($savings->count() > 0)
                <tfoot>
                    <tr class="table-info">
                        <td colspan="4" class="text-end"><strong>Total:</strong></td>
                        <td class="text-end">
                            <strong>₹{{ number_format($summary['total_deposits'] - $summary['total_withdrawals'], 2) }}</strong>
                        </td>
                        <td colspan="3"></td>
                    </tr>
                </tfoot>
                @endif
            </table>
        </div>
    </div>
</div>
@endsection



