@extends('layouts.app')

@section('title', 'Overdue Report')
@section('page-title', 'Overdue Report')

@section('content')
<style>
    @media print {
        .no-print { display: none !important; }
        .card { border: none !important; box-shadow: none !important; }
    }
</style>

<div class="card no-print mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('partner.reports.overdue') }}" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Minimum Days Overdue</label>
                <input type="number" name="days" class="form-control" value="{{ request('days') }}" placeholder="e.g., 30">
                <small class="text-muted">Show loans overdue by at least this many days</small>
            </div>
            <div class="col-md-4 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="{{ route('partner.reports.overdue') }}" class="btn btn-secondary">Reset</a>
                <button type="button" onclick="window.print()" class="btn btn-info">
                    <i class="bi bi-printer me-2"></i>Print
                </button>
            </div>
        </form>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-4">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Overdue</h6>
                <h3 style="color: var(--danger);">{{ $summary['total_overdue'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Amount</h6>
                <h3 style="color: var(--text-heading);">₹{{ number_format($summary['total_amount'], 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Avg Days Overdue</h6>
                <h3 style="color: var(--text-heading);">{{ $summary['avg_days_overdue'] }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Overdue Loans</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Loan #</th>
                        <th>Customer</th>
                        <th>Scheme</th>
                        <th>Due Date</th>
                        <th class="text-end">Days Overdue</th>
                        <th class="text-end">Outstanding</th>
                        <th class="text-end">Installment</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($loans as $loan)
                    <tr>
                        <td>{{ $loan->loan_number }}</td>
                        <td>{{ $loan->customer->name }}</td>
                        <td>{{ $loan->loanScheme?->name ?? $loan->scheme?->name ?? 'N/A' }}</td>
                        <td>{{ $loan->due_date->format('d M Y') }}</td>
                        <td class="text-end">
                            <span class="badge bg-danger">{{ $loan->days_overdue }} days</span>
                        </td>
                        <td class="text-end text-warning">₹{{ number_format($loan->overdue_amount, 2) }}</td>
                        <td class="text-end">₹{{ number_format($loan->monthly_installment, 2) }}</td>
                        <td>
                            <span class="badge bg-danger">Overdue</span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="bi bi-check-circle" style="font-size: 2rem; color: var(--success);"></i>
                            <p class="text-muted mt-2 mb-0">No overdue loans found</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
                @if($loans->count() > 0)
                <tfoot>
                    <tr class="table-danger">
                        <td colspan="4" class="text-end"><strong>Total:</strong></td>
                        <td></td>
                        <td class="text-end"><strong>₹{{ number_format($loans->sum('overdue_amount'), 2) }}</strong></td>
                        <td class="text-end"><strong>₹{{ number_format($loans->sum('monthly_installment'), 2) }}</strong></td>
                        <td></td>
                    </tr>
                </tfoot>
                @endif
            </table>
        </div>
    </div>
</div>
@endsection


