@extends('layouts.app')

@section('title', 'Collection Report')
@section('page-title', 'Collection Report')

@section('content')
<style>
    @media print {
        .no-print { display: none !important; }
        .card { border: none !important; box-shadow: none !important; }
    }
</style>

<div class="card no-print mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('partner.reports.collection') }}" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}">
            </div>
            <div class="col-md-3">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}">
            </div>
            <div class="col-md-3 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="{{ route('partner.reports.collection') }}" class="btn btn-secondary">Reset</a>
                <button type="button" onclick="window.print()" class="btn btn-info">
                    <i class="bi bi-printer me-2"></i>Print
                </button>
            </div>
        </form>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Collected</h6>
                <h3 style="color: var(--success);">₹{{ number_format($summary['total_collected'], 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Principal</h6>
                <h3 style="color: var(--text-heading);">₹{{ number_format($summary['total_principal'], 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Interest</h6>
                <h3 style="color: var(--info);">₹{{ number_format($summary['total_interest'], 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Avg Daily</h6>
                <h3 style="color: var(--text-heading);">₹{{ number_format($summary['avg_daily_collection'], 2) }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title mb-0">Daily Collection Summary</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th class="text-end">Transactions</th>
                        <th class="text-end">Total Amount</th>
                        <th class="text-end">Principal</th>
                        <th class="text-end">Interest</th>
                        <th class="text-end">Penalty</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($dailyCollections as $collection)
                    <tr>
                        <td>{{ $collection['date']->format('d M Y') }}</td>
                        <td class="text-end">{{ $collection['count'] }}</td>
                        <td class="text-end">₹{{ number_format($collection['total'], 2) }}</td>
                        <td class="text-end">₹{{ number_format($collection['principal'], 2) }}</td>
                        <td class="text-end">₹{{ number_format($collection['interest'], 2) }}</td>
                        <td class="text-end">₹{{ number_format($collection['penalty'], 2) }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No collections found</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Collection Details</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Repayment #</th>
                        <th>Loan #</th>
                        <th>Customer</th>
                        <th>Payment Date</th>
                        <th class="text-end">Amount</th>
                        <th class="text-end">Principal</th>
                        <th class="text-end">Interest</th>
                        <th class="text-end">Penalty</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($repayments as $repayment)
                    <tr>
                        <td>{{ $repayment->repayment_number }}</td>
                        <td>{{ $repayment->loan->loan_number }}</td>
                        <td>{{ $repayment->customer->name }}</td>
                        <td>{{ $repayment->payment_date->format('d M Y') }}</td>
                        <td class="text-end">₹{{ number_format($repayment->amount, 2) }}</td>
                        <td class="text-end">₹{{ number_format($repayment->principal_amount, 2) }}</td>
                        <td class="text-end">₹{{ number_format($repayment->interest_amount, 2) }}</td>
                        <td class="text-end">₹{{ number_format($repayment->penalty_amount, 2) }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No repayments found</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection



