@extends('layouts.app')

@section('title', 'Balance Sheet')
@section('page-title', 'Balance Sheet')

@section('content')
<style>
    @media print {
        .no-print { display: none !important; }
        .card { border: none !important; box-shadow: none !important; }
    }
    .balance-sheet-section {
        margin-bottom: 2rem;
    }
    .balance-sheet-item {
        display: flex;
        justify-content: space-between;
        padding: 10px 15px;
        border-bottom: 1px solid var(--border-color);
    }
    .balance-sheet-item.total {
        font-weight: 700;
        background: var(--hover-bg);
        border-top: 2px solid var(--primary);
    }
    .balance-sheet-item.subtotal {
        font-weight: 600;
        background: var(--hover-bg);
    }
</style>

<div class="card no-print mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('partner.reports.balance-sheet') }}" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">As On Date</label>
                <input type="date" name="as_on_date" class="form-control" value="{{ request('as_on_date', now()->format('Y-m-d')) }}">
            </div>
            <div class="col-md-4 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Generate
                </button>
                <button type="button" onclick="window.print()" class="btn btn-info">
                    <i class="bi bi-printer me-2"></i>Print
                </button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header text-center">
        <h4 class="mb-0">{{ auth()->user()->partner->company_name ?? auth()->user()->partner->name }}</h4>
        <h5 class="mb-0">Balance Sheet</h5>
        <p class="mb-0 text-muted">As On: {{ $asOnDate->format('d F Y') }}</p>
    </div>
    <div class="card-body">
        <div class="row">
            <!-- Assets -->
            <div class="col-md-6">
                <div class="balance-sheet-section">
                    <h5 class="mb-3" style="color: var(--text-heading);">ASSETS</h5>
                    <div class="balance-sheet-item">
                        <span>Loans Disbursed</span>
                        <strong>₹{{ number_format($assets['loans_disbursed'], 2) }}</strong>
                    </div>
                    <div class="balance-sheet-item">
                        <span>Outstanding Loans</span>
                        <strong>₹{{ number_format($assets['outstanding_loans'], 2) }}</strong>
                    </div>
                    <div class="balance-sheet-item">
                        <span>Savings Balance</span>
                        <strong>₹{{ number_format($assets['savings_balance'], 2) }}</strong>
                    </div>
                    <div class="balance-sheet-item total">
                        <span>TOTAL ASSETS</span>
                        <strong>₹{{ number_format($assets['total_assets'], 2) }}</strong>
                    </div>
                </div>
            </div>

            <!-- Liabilities & Equity -->
            <div class="col-md-6">
                <div class="balance-sheet-section">
                    <h5 class="mb-3" style="color: var(--text-heading);">LIABILITIES</h5>
                    <div class="balance-sheet-item">
                        <span>Savings Deposits</span>
                        <strong>₹{{ number_format($liabilities['savings_deposits'], 2) }}</strong>
                    </div>
                    <div class="balance-sheet-item total">
                        <span>TOTAL LIABILITIES</span>
                        <strong>₹{{ number_format($liabilities['total_liabilities'], 2) }}</strong>
                    </div>
                </div>

                <div class="balance-sheet-section mt-4">
                    <h5 class="mb-3" style="color: var(--text-heading);">INCOME</h5>
                    <div class="balance-sheet-item">
                        <span>Interest Earned</span>
                        <strong>₹{{ number_format($income['interest_earned'], 2) }}</strong>
                    </div>
                    <div class="balance-sheet-item">
                        <span>Penalty Earned</span>
                        <strong>₹{{ number_format($income['penalty_earned'], 2) }}</strong>
                    </div>
                    <div class="balance-sheet-item">
                        <span>Processing Fees</span>
                        <strong>₹{{ number_format($income['processing_fees'], 2) }}</strong>
                    </div>
                    <div class="balance-sheet-item">
                        <span>Insurance Fees</span>
                        <strong>₹{{ number_format($income['insurance_fees'], 2) }}</strong>
                    </div>
                    <div class="balance-sheet-item">
                        <span>Other Fees</span>
                        <strong>₹{{ number_format($income['other_fees'], 2) }}</strong>
                    </div>
                    <div class="balance-sheet-item subtotal">
                        <span>TOTAL INCOME</span>
                        <strong>₹{{ number_format($income['total_income'], 2) }}</strong>
                    </div>
                </div>

                <div class="balance-sheet-section mt-4">
                    <div class="balance-sheet-item total" style="background: linear-gradient(135deg, rgba(115, 103, 240, 0.1) 0%, rgba(115, 103, 240, 0.05) 100%);">
                        <span>NET WORTH</span>
                        <strong style="color: var(--primary); font-size: 1.2rem;">₹{{ number_format($netWorth, 2) }}</strong>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection



