@extends('layouts.app')

@section('title', 'Company Profile')
@section('page-title', 'Company Profile')

@section('content')
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Company Information</h5>
        <a href="{{ route('partner.profile.edit') }}" class="btn btn-primary btn-sm">
            <i class="bi bi-pencil"></i> Edit Profile
        </a>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-4 text-center mb-4 mb-md-0">
                @if($partner->logo)
                    <img src="{{ Storage::url($partner->logo) }}" alt="Company Logo" 
                         class="img-fluid rounded" style="max-height: 200px; max-width: 100%; object-fit: contain;">
                @else
                    <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                         style="height: 200px; width: 100%;">
                        <i class="bi bi-building text-muted" style="font-size: 4rem;"></i>
                    </div>
                    <p class="text-muted mt-2 mb-0"><small>No logo uploaded</small></p>
                @endif
            </div>
            <div class="col-md-8">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <p class="mb-1"><strong>Company Name:</strong></p>
                        <p class="text-muted">{{ $partner->company_name ?? 'Not set' }}</p>
                    </div>
                    <div class="col-md-6 mb-3">
                        <p class="mb-1"><strong>Contact Person:</strong></p>
                        <p class="text-muted">{{ $partner->name }}</p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <p class="mb-1"><strong><i class="bi bi-envelope me-1"></i>Email:</strong></p>
                        <p class="text-muted">{{ $partner->email }}</p>
                    </div>
                    <div class="col-md-6 mb-3">
                        <p class="mb-1"><strong><i class="bi bi-telephone me-1"></i>Phone:</strong></p>
                        <p class="text-muted">{{ $partner->phone ?? 'Not set' }}</p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <p class="mb-1"><strong><i class="bi bi-whatsapp me-1"></i>WhatsApp:</strong></p>
                        <p class="text-muted">
                            @if($partner->whatsapp)
                                <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $partner->whatsapp) }}" 
                                   target="_blank" class="text-decoration-none">
                                    {{ $partner->whatsapp }} <i class="bi bi-box-arrow-up-right"></i>
                                </a>
                            @else
                                Not set
                            @endif
                        </p>
                    </div>
                    <div class="col-md-6 mb-3">
                        <p class="mb-1"><strong>Status:</strong></p>
                        <span class="badge bg-{{ $partner->status === 'active' ? 'success' : ($partner->status === 'inactive' ? 'secondary' : 'warning') }}">
                            {{ ucfirst($partner->status) }}
                        </span>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12 mb-3">
                        <p class="mb-1"><strong><i class="bi bi-geo-alt me-1"></i>Address:</strong></p>
                        <p class="text-muted">{{ $partner->address ?? 'Not set' }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Quick Actions</h5>
    </div>
    <div class="card-body">
        <div class="d-grid d-md-flex gap-2">
            <a href="{{ route('partner.profile.edit') }}" class="btn btn-primary">
                <i class="bi bi-pencil me-1"></i>Edit Company Profile
            </a>
            <a href="{{ route('partner.dashboard') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-1"></i>Back to Dashboard
            </a>
        </div>
    </div>
</div>
@endsection



