@extends('layouts.app')

@section('title', 'Edit Company Profile')
@section('page-title', 'Edit Company Profile')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Update Company Profile</h5>
        <a href="{{ route('partner.profile.show') }}" class="btn btn-secondary btn-sm">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        <form action="{{ route('partner.profile.update') }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            
            <div class="row mb-4">
                <div class="col-md-12 text-center">
                    <div class="mb-3">
                        @if($partner->logo)
                            <img src="{{ Storage::url($partner->logo) }}" alt="Current Logo" 
                                 class="img-fluid rounded mb-2" 
                                 style="max-height: 150px; max-width: 100%; object-fit: contain;" 
                                 id="logoPreview">
                        @else
                            <div class="bg-light rounded d-flex align-items-center justify-content-center mx-auto mb-2" 
                                 style="height: 150px; width: 200px;" id="logoPreview">
                                <i class="bi bi-building text-muted" style="font-size: 3rem;"></i>
                            </div>
                        @endif
                    </div>
                    <label for="logo" class="form-label">Company Logo</label>
                    <input type="file" 
                           class="form-control @error('logo') is-invalid @enderror" 
                           id="logo" 
                           name="logo" 
                           accept="image/*"
                           onchange="previewLogo(this)">
                    @error('logo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted">Recommended: 300x300px, Max size: 2MB (JPG, PNG, GIF, SVG)</small>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="company_name" class="form-label">Company Name *</label>
                    <input type="text" 
                           class="form-control @error('company_name') is-invalid @enderror" 
                           id="company_name" 
                           name="company_name" 
                           value="{{ old('company_name', $partner->company_name) }}" 
                           required>
                    @error('company_name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="email" class="form-label">Email Address *</label>
                    <input type="email" 
                           class="form-control @error('email') is-invalid @enderror" 
                           id="email" 
                           name="email" 
                           value="{{ old('email', $partner->email) }}" 
                           required>
                    @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="phone" class="form-label">
                        <i class="bi bi-telephone me-1"></i>Phone Number
                    </label>
                    <input type="text" 
                           class="form-control @error('phone') is-invalid @enderror" 
                           id="phone" 
                           name="phone" 
                           value="{{ old('phone', $partner->phone) }}"
                           placeholder="+1234567890">
                    @error('phone')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="whatsapp" class="form-label">
                        <i class="bi bi-whatsapp me-1"></i>WhatsApp Number
                    </label>
                    <input type="text" 
                           class="form-control @error('whatsapp') is-invalid @enderror" 
                           id="whatsapp" 
                           name="whatsapp" 
                           value="{{ old('whatsapp', $partner->whatsapp) }}"
                           placeholder="+1234567890">
                    @error('whatsapp')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted">Include country code (e.g., +91 for India)</small>
                </div>
            </div>

            <div class="mb-3">
                <label for="address" class="form-label">
                    <i class="bi bi-geo-alt me-1"></i>Company Address
                </label>
                <textarea class="form-control @error('address') is-invalid @enderror" 
                          id="address" 
                          name="address" 
                          rows="3"
                          placeholder="Enter complete company address">{{ old('address', $partner->address) }}</textarea>
                @error('address')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> Update Profile
                </button>
                <a href="{{ route('partner.profile.show') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
    function previewLogo(input) {
        const preview = document.getElementById('logoPreview');
        
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                if (preview.tagName === 'IMG') {
                    preview.src = e.target.result;
                } else {
                    preview.innerHTML = `<img src="${e.target.result}" class="img-fluid rounded" style="max-height: 150px; max-width: 100%; object-fit: contain;">`;
                }
            };
            
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endpush
@endpush



