@extends('layouts.app')

@section('title', 'Penalty Details')
@section('page-title', 'Penalty Details')

@section('content')
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Penalty Information</h5>
        <div>
            <form action="{{ route('partner.penalties.update', $penalty) }}" method="POST" class="d-inline">
                @csrf
                @method('PUT')
                <select name="status" class="form-select form-select-sm d-inline-block w-auto" onchange="this.form.submit()">
                    <option value="pending" {{ $penalty->status === 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="paid" {{ $penalty->status === 'paid' ? 'selected' : '' }}>Paid</option>
                    <option value="waived" {{ $penalty->status === 'waived' ? 'selected' : '' }}>Waived</option>
                </select>
            </form>
            <a href="{{ route('partner.penalties.index') }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>Penalty Number:</strong> {{ $penalty->penalty_number }}</p>
                <p><strong>Loan Number:</strong> {{ $penalty->loan->loan_number }}</p>
                <p><strong>Customer:</strong> {{ $penalty->customer->name }}</p>
                <p><strong>Amount:</strong> ₹{{ number_format($penalty->amount, 2) }}</p>
            </div>
            <div class="col-md-6">
                <p><strong>Type:</strong> {{ ucfirst(str_replace('_', ' ', $penalty->type)) }}</p>
                <p><strong>Days Overdue:</strong> {{ $penalty->days_overdue }}</p>
                <p><strong>Due Date:</strong> {{ $penalty->due_date->format('d M Y') }}</p>
                <p><strong>Penalty Date:</strong> {{ $penalty->penalty_date->format('d M Y') }}</p>
                <p><strong>Status:</strong> 
                    <span class="badge bg-{{ $penalty->status === 'paid' ? 'success' : ($penalty->status === 'waived' ? 'info' : 'warning') }}">
                        {{ ucfirst($penalty->status) }}
                    </span>
                </p>
            </div>
        </div>
        @if($penalty->description)
        <div class="mt-3">
            <p><strong>Description:</strong> {{ $penalty->description }}</p>
        </div>
        @endif
    </div>
</div>
@endsection

