@extends('layouts.app')

@section('title', 'Create Penalty')
@section('page-title', 'Create Penalty')

@section('content')
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Add Penalty</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('partner.penalties.store') }}" method="POST">
            @csrf
            <div class="mb-3">
                <label for="loan_id" class="form-label">Loan *</label>
                <select class="form-select @error('loan_id') is-invalid @enderror" id="loan_id" name="loan_id" required>
                    <option value="">Select Loan</option>
                    @foreach($loans as $loan)
                        <option value="{{ $loan->id }}" {{ old('loan_id') == $loan->id ? 'selected' : '' }}>
                            {{ $loan->loan_number }} - {{ $loan->customer->name }}
                        </option>
                    @endforeach
                </select>
                @error('loan_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="amount" class="form-label">Penalty Amount *</label>
                    <input type="number" step="0.01" class="form-control @error('amount') is-invalid @enderror" 
                           id="amount" name="amount" value="{{ old('amount') }}" required>
                    @error('amount')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="penalty_date" class="form-label">Penalty Date *</label>
                    <input type="date" class="form-control @error('penalty_date') is-invalid @enderror" 
                           id="penalty_date" name="penalty_date" value="{{ old('penalty_date', date('Y-m-d')) }}" required>
                    @error('penalty_date')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="mb-3">
                <label for="type" class="form-label">Type *</label>
                <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                    <option value="late_payment" {{ old('type') === 'late_payment' ? 'selected' : '' }}>Late Payment</option>
                    <option value="default" {{ old('type') === 'default' ? 'selected' : '' }}>Default</option>
                    <option value="other" {{ old('type') === 'other' ? 'selected' : '' }}>Other</option>
                </select>
                @error('type')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            <div class="mb-3">
                <label for="description" class="form-label">Description</label>
                <textarea class="form-control" id="description" name="description" rows="3">{{ old('description') }}</textarea>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> Create Penalty
                </button>
                <a href="{{ route('partner.penalties.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection

