@extends('layouts.app')

@section('title', 'Loan Details')
@section('page-title', 'Loan Details')

@section('content')
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Loan Information</h5>
        <div class="d-flex gap-2 flex-wrap">
            @if($loan->status === 'active' && $loan->due_date < now() && ($loan->loanScheme?->late_fee_type || $loan->scheme?->late_fee_type))
            <form action="{{ route('partner.loans.apply-late-fee', $loan) }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-warning btn-sm">
                    <i class="bi bi-exclamation-triangle"></i> Apply Late Fee
                </button>
            </form>
            @endif
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown">
                    <i class="bi bi-file-earmark-pdf"></i> Documents
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="{{ route('partner.loans.statement', $loan) }}" target="_blank">
                        <i class="bi bi-file-text me-2"></i>Loan Statement
                    </a></li>
                    <li><a class="dropdown-item" href="{{ route('partner.loans.schedule', $loan) }}" target="_blank">
                        <i class="bi bi-calendar-check me-2"></i>Repayment Schedule
                    </a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="{{ route('partner.loans.sanction-letter', $loan) }}" target="_blank">
                        <i class="bi bi-file-earmark-check me-2"></i>Sanction Letter
                    </a></li>
                    <li><a class="dropdown-item" href="{{ route('partner.loans.noc', $loan) }}" target="_blank">
                        <i class="bi bi-file-earmark-medical me-2"></i>NOC (No Objection Certificate)
                    </a></li>
                </ul>
            </div>
            <a href="{{ route('partner.loans.index') }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>Loan Number:</strong> {{ $loan->loan_number }}</p>
                <p><strong>Customer:</strong> {{ $loan->customer->name }}</p>
                <p><strong>Scheme:</strong> {{ $loan->loanScheme?->name ?? $loan->scheme?->name ?? 'N/A' }}</p>
                <p><strong>Principal Amount:</strong> ₹{{ number_format($loan->principal_amount, 2) }}</p>
                <p><strong>Interest Rate:</strong> {{ $loan->interest_rate }}{{ ($loan->loanScheme?->interest_type ?? $loan->scheme?->interest_type) === 'flat' ? ' (Flat)' : '%' }}</p>
                <p><strong>Interest Amount:</strong> ₹{{ number_format($loan->interest_amount, 2) }}</p>
                <p><strong>Duration:</strong> {{ $loan->duration_value }} {{ ucfirst($loan->duration_type) }}</p>
            </div>
            <div class="col-md-6">
                <p><strong>Processing Fee:</strong> ₹{{ number_format($loan->processing_fee, 2) }}</p>
                <p><strong>Insurance Fee:</strong> ₹{{ number_format($loan->insurance_fee, 2) }}</p>
                <p><strong>Other Fee:</strong> ₹{{ number_format($loan->other_fee, 2) }}</p>
                <p><strong>Total Amount:</strong> ₹{{ number_format($loan->total_amount, 2) }}</p>
                <p><strong>Paid Amount:</strong> ₹{{ number_format($loan->paid_amount, 2) }}</p>
                <p><strong>Remaining Amount:</strong> ₹{{ number_format($loan->remaining_amount, 2) }}</p>
                <p><strong>Installment Amount:</strong> ₹{{ number_format($loan->monthly_installment, 2) }}</p>
                <p><strong>Disbursement Date:</strong> {{ $loan->disbursement_date->format('d M Y') }}</p>
                <p><strong>Maturity Date:</strong> {{ $loan->maturity_date->format('d M Y') }}</p>
                <p><strong>Status:</strong> 
                    <span class="badge bg-{{ $loan->status === 'active' ? 'success' : ($loan->status === 'completed' ? 'info' : 'secondary') }}">
                        {{ ucfirst($loan->status) }}
                    </span>
                </p>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Repayments</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Principal</th>
                                <th>Interest</th>
                                <th>Penalty</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($loan->repayments as $repayment)
                            <tr>
                                <td>{{ $repayment->payment_date->format('d M Y') }}</td>
                                <td>₹{{ number_format($repayment->amount, 2) }}</td>
                                <td>₹{{ number_format($repayment->principal_amount, 2) }}</td>
                                <td>₹{{ number_format($repayment->interest_amount, 2) }}</td>
                                <td>₹{{ number_format($repayment->penalty_amount, 2) }}</td>
                                <td>
                                    <span class="badge bg-{{ $repayment->status === 'on_time' ? 'success' : 'warning' }}">
                                        {{ ucfirst(str_replace('_', ' ', $repayment->status)) }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('partner.repayments.slip', $repayment) }}" 
                                       class="btn btn-sm btn-outline-primary" target="_blank" title="Print Slip">
                                        <i class="bi bi-printer"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center">No repayments found.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Late Fees / Penalties</h5>
            </div>
            <div class="card-body">
                @php
                    $scheme = $loan->loanScheme ?? $loan->scheme;
                @endphp
                @if($scheme?->late_fee_type)
                <div class="mb-3">
                    <small class="text-muted">Late Fee: 
                        {{ $scheme->late_fee_value }} 
                        {{ $scheme->late_fee_type === 'percentage' ? '%' : '₹' }}
                        {{ $scheme->late_fee_type === 'percentage' ? 'of installment' : 'per day' }}
                    </small>
                </div>
                @endif
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($loan->penalties as $penalty)
                            <tr>
                                <td>{{ $penalty->penalty_date->format('d M Y') }}</td>
                                <td>₹{{ number_format($penalty->amount, 2) }}</td>
                                <td>
                                    <span class="badge bg-{{ $penalty->status === 'paid' ? 'success' : ($penalty->status === 'waived' ? 'info' : 'warning') }}">
                                        {{ ucfirst($penalty->status) }}
                                    </span>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="3" class="text-center text-muted">
                                    <small>No penalties</small>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if($loan->penalties->where('status', 'pending')->count() > 0)
                <div class="mt-2">
                    <strong class="text-danger">
                        Total Pending: ₹{{ number_format($loan->penalties->where('status', 'pending')->sum('amount'), 2) }}
                    </strong>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

