@extends('layouts.app')

@section('title', 'Create Loan')
@section('page-title', 'Create Loan')

@section('content')
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Create New Loan</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('partner.loans.store') }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="customer_id" class="form-label">Customer *</label>
                    <select class="form-select @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id" required>
                        <option value="">Select Customer</option>
                        @foreach($customers as $customer)
                            <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>
                                {{ $customer->name }} ({{ $customer->customer_code }})
                            </option>
                        @endforeach
                    </select>
                    @error('customer_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="scheme_id" class="form-label">Scheme *</label>
                    <select class="form-select @error('scheme_id') is-invalid @enderror" id="scheme_id" name="scheme_id" required>
                        <option value="">Select Scheme</option>
                        @foreach($schemes as $scheme)
                            <option value="{{ $scheme->id }}" {{ old('scheme_id') == $scheme->id ? 'selected' : '' }}>
                                {{ $scheme->name }} ({{ $scheme->interest_rate }}%)
                            </option>
                        @endforeach
                    </select>
                    @error('scheme_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 mb-3">
                    <label for="principal_amount" class="form-label">Principal Amount *</label>
                    <input type="number" step="0.01" class="form-control @error('principal_amount') is-invalid @enderror" 
                           id="principal_amount" name="principal_amount" value="{{ old('principal_amount') }}" required>
                    @error('principal_amount')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="duration_type" class="form-label">Duration Type <small class="text-muted">(Optional - uses scheme default)</small></label>
                    <select class="form-select @error('duration_type') is-invalid @enderror" id="duration_type" name="duration_type">
                        <option value="">Use Scheme Default</option>
                        <option value="daily" {{ old('duration_type') === 'daily' ? 'selected' : '' }}>Daily</option>
                        <option value="weekly" {{ old('duration_type') === 'weekly' ? 'selected' : '' }}>Weekly</option>
                        <option value="monthly" {{ old('duration_type') === 'monthly' ? 'selected' : '' }}>Monthly</option>
                    </select>
                    @error('duration_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="duration_value" class="form-label">Duration Value <small class="text-muted">(Optional - uses scheme default)</small></label>
                    <input type="number" class="form-control @error('duration_value') is-invalid @enderror" 
                           id="duration_value" name="duration_value" value="{{ old('duration_value') }}" 
                           placeholder="e.g., 30 for 30 days/weeks/months">
                    @error('duration_value')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="alert alert-info mb-3">
                <i class="bi bi-info-circle me-2"></i>
                <strong>Note:</strong> If duration is not specified, the scheme's default duration will be used. 
                Processing fee, insurance fee, and other fees from the scheme will be automatically added to the loan total.
            </div>
            <div class="mb-3">
                <label for="disbursement_date" class="form-label">Disbursement Date *</label>
                <input type="date" class="form-control @error('disbursement_date') is-invalid @enderror" 
                       id="disbursement_date" name="disbursement_date" value="{{ old('disbursement_date', date('Y-m-d')) }}" required>
                @error('disbursement_date')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            <div class="mb-3">
                <label for="notes" class="form-label">Notes</label>
                <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> Create Loan
                </button>
                <a href="{{ route('partner.loans.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection

