@extends('layouts.app')

@section('title', 'Loan Schemes')
@section('page-title', 'Loan Schemes')

@section('content')
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Loan Schemes</h5>
        <a href="{{ route('partner.loan-schemes.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> New Loan Scheme
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Interest Rate</th>
                        <th>Duration</th>
                        <th>Min Amount</th>
                        <th>Max Amount</th>
                        <th>Processing Fee</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($schemes as $scheme)
                    <tr>
                        <td>
                            <strong>{{ $scheme->name }}</strong>
                            @if($scheme->description)
                                <br><small class="text-muted">{{ \Illuminate\Support\Str::limit($scheme->description, 50) }}</small>
                            @endif
                        </td>
                        <td>{{ $scheme->interest_rate }}% ({{ ucfirst($scheme->interest_type) }})</td>
                        <td>{{ $scheme->duration_value }} {{ ucfirst($scheme->duration_type) }}</td>
                        <td>₹{{ number_format($scheme->min_amount, 2) }}</td>
                        <td>₹{{ number_format($scheme->max_amount ?? 0, 2) }}</td>
                        <td>₹{{ number_format($scheme->processing_fee, 2) }}</td>
                        <td>
                            <span class="badge bg-{{ $scheme->status === 'active' ? 'success' : 'secondary' }}">
                                {{ ucfirst($scheme->status) }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group">
                                <a href="{{ route('partner.loan-schemes.show', $scheme) }}" class="btn btn-sm btn-info" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="{{ route('partner.loan-schemes.edit', $scheme) }}" class="btn btn-sm btn-warning" title="Edit">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="{{ route('partner.loan-schemes.destroy', $scheme) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this loan scheme?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No loan schemes found</p>
                            <a href="{{ route('partner.loan-schemes.create') }}" class="btn btn-primary mt-3">
                                <i class="bi bi-plus-circle"></i> Create First Loan Scheme
                            </a>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $schemes->links() }}
        </div>
    </div>
</div>
@endsection

