@extends('layouts.app')

@section('title', 'Add Subscription')
@section('page-title', 'Add Subscription Manually')

@section('content')
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Create New Subscription</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.subscriptions.store') }}" method="POST">
            @csrf
            
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>
                <strong>Note:</strong> This will manually create a subscription for a partner. 
                Make sure to set appropriate dates and status.
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="partner_id" class="form-label">Partner *</label>
                    <select class="form-select @error('partner_id') is-invalid @enderror" id="partner_id" name="partner_id" required>
                        <option value="">Select Partner</option>
                        @foreach($partners as $partner)
                            <option value="{{ $partner->id }}" {{ old('partner_id') == $partner->id ? 'selected' : '' }}>
                                {{ $partner->name }} @if($partner->company_name) - {{ $partner->company_name }} @endif
                            </option>
                        @endforeach
                    </select>
                    @error('partner_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="plan_type" class="form-label">Plan Type *</label>
                    <select class="form-select @error('plan_type') is-invalid @enderror" id="plan_type" name="plan_type" required>
                        <option value="monthly" {{ old('plan_type', 'monthly') === 'monthly' ? 'selected' : '' }}>Monthly (₹300)</option>
                        <option value="yearly" {{ old('plan_type') === 'yearly' ? 'selected' : '' }}>Yearly (₹3,240 - 10% discount)</option>
                    </select>
                    @error('plan_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="amount" class="form-label">Amount *</label>
                    <input type="number" step="0.01" class="form-control @error('amount') is-invalid @enderror" 
                           id="amount" name="amount" value="{{ old('amount') }}" required>
                    @error('amount')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted">Monthly: ₹300, Yearly: ₹3,240</small>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="status" class="form-label">Status *</label>
                    <select class="form-select @error('status') is-invalid @enderror" id="status" name="status" required>
                        <option value="pending" {{ old('status', 'pending') === 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="active" {{ old('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="expired" {{ old('status') === 'expired' ? 'selected' : '' }}>Expired</option>
                        <option value="cancelled" {{ old('status') === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                    @error('status')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="start_date" class="form-label">Start Date *</label>
                    <input type="date" class="form-control @error('start_date') is-invalid @enderror" 
                           id="start_date" name="start_date" value="{{ old('start_date', now()->format('Y-m-d')) }}" required>
                    @error('start_date')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="end_date" class="form-label">End Date *</label>
                    <input type="date" class="form-control @error('end_date') is-invalid @enderror" 
                           id="end_date" name="end_date" value="{{ old('end_date') }}" required>
                    @error('end_date')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted">Will be auto-calculated based on plan type if left empty</small>
                </div>
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save me-2"></i>Create Subscription
                </button>
                <a href="{{ route('admin.subscriptions.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
    document.getElementById('plan_type').addEventListener('change', function() {
        const planType = this.value;
        const amountInput = document.getElementById('amount');
        const startDateInput = document.getElementById('start_date');
        const endDateInput = document.getElementById('end_date');
        
        // Set amount
        if (planType === 'monthly') {
            amountInput.value = '300';
        } else if (planType === 'yearly') {
            amountInput.value = '3240';
        }
        
        // Auto-calculate end date
        if (startDateInput.value) {
            const startDate = new Date(startDateInput.value);
            if (planType === 'monthly') {
                startDate.setMonth(startDate.getMonth() + 1);
            } else if (planType === 'yearly') {
                startDate.setFullYear(startDate.getFullYear() + 1);
            }
            endDateInput.value = startDate.toISOString().split('T')[0];
        }
    });
    
    document.getElementById('start_date').addEventListener('change', function() {
        const planType = document.getElementById('plan_type').value;
        const endDateInput = document.getElementById('end_date');
        
        if (this.value && planType) {
            const startDate = new Date(this.value);
            if (planType === 'monthly') {
                startDate.setMonth(startDate.getMonth() + 1);
            } else if (planType === 'yearly') {
                startDate.setFullYear(startDate.getFullYear() + 1);
            }
            endDateInput.value = startDate.toISOString().split('T')[0];
        }
    });
</script>
@endpush
@endsection


