@extends('layouts.app')

@section('title', 'Razorpay Settings')
@section('page-title', 'Razorpay Settings')

@section('content')
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Razorpay API Configuration</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.razorpay-settings.update') }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>
                <strong>Note:</strong> These credentials are used for processing subscription payments. 
                Make sure to use the correct API keys from your Razorpay dashboard.
                <br><br>
                <strong>How to get Razorpay API Keys:</strong>
                <ol class="mb-0 mt-2">
                    <li>Login to your Razorpay Dashboard</li>
                    <li>Go to Settings → API Keys</li>
                    <li>Generate or copy your Key ID and Key Secret</li>
                    <li>For testing, use Test Mode keys (starts with rzp_test_)</li>
                    <li>For production, use Live Mode keys (starts with rzp_live_)</li>
                </ol>
            </div>
            
            @if(empty($razorpayKey) || empty($razorpaySecret))
            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <strong>Warning:</strong> Razorpay API credentials are not configured. Partners will not be able to make payments until these are set.
            </div>
            @endif

            <div class="mb-3">
                <label for="razorpay_key" class="form-label">Razorpay API Key *</label>
                <input type="text" 
                       class="form-control @error('razorpay_key') is-invalid @enderror" 
                       id="razorpay_key" 
                       name="razorpay_key" 
                       value="{{ old('razorpay_key', $razorpayKey) }}" 
                       placeholder="rzp_test_xxxxxxxxxxxxx"
                       required>
                @error('razorpay_key')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <small class="text-muted">Your Razorpay API Key (starts with rzp_test_ for test mode or rzp_live_ for live mode)</small>
            </div>

            <div class="mb-3">
                <label for="razorpay_secret" class="form-label">Razorpay API Secret *</label>
                <input type="password" 
                       class="form-control @error('razorpay_secret') is-invalid @enderror" 
                       id="razorpay_secret" 
                       name="razorpay_secret" 
                       value="{{ old('razorpay_secret', $razorpaySecret) }}" 
                       placeholder="Enter API Secret"
                       required>
                @error('razorpay_secret')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <small class="text-muted">Your Razorpay API Secret Key</small>
                <div class="form-check mt-2">
                    <input class="form-check-input" type="checkbox" id="show_secret" onchange="toggleSecretVisibility()">
                    <label class="form-check-label" for="show_secret">
                        Show Secret
                    </label>
                </div>
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save me-2"></i>Update Settings
                </button>
                <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
    function toggleSecretVisibility() {
        const secretInput = document.getElementById('razorpay_secret');
        const showCheckbox = document.getElementById('show_secret');
        
        if (showCheckbox.checked) {
            secretInput.type = 'text';
        } else {
            secretInput.type = 'password';
        }
    }
</script>
@endpush
@endsection

