@extends('layouts.app')

@section('title', 'Partner Details')
@section('page-title', 'Partner Details')

@section('content')
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Partner Information</h5>
        <div>
            <a href="{{ route('admin.partners.edit', $partner) }}" class="btn btn-warning btn-sm">
                <i class="bi bi-pencil"></i> Edit
            </a>
            <a href="{{ route('admin.partners.index') }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>Name:</strong> {{ $partner->name }}</p>
                <p><strong>Email:</strong> {{ $partner->email }}</p>
                <p><strong>Phone:</strong> {{ $partner->phone ?? 'N/A' }}</p>
                <p><strong>WhatsApp:</strong> 
                    @if($partner->whatsapp)
                        <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $partner->whatsapp) }}" 
                           target="_blank" class="text-decoration-none">
                            {{ $partner->whatsapp }} <i class="bi bi-box-arrow-up-right"></i>
                        </a>
                    @else
                        N/A
                    @endif
                </p>
            </div>
            <div class="col-md-6">
                <p><strong>Company:</strong> {{ $partner->company_name ?? 'N/A' }}</p>
                @if($partner->logo)
                <p><strong>Logo:</strong> 
                    <img src="{{ Storage::url($partner->logo) }}" alt="Company Logo" 
                         class="img-fluid rounded" style="max-height: 100px;">
                </p>
                @endif
                <p><strong>Status:</strong> 
                    <span class="badge bg-{{ $partner->status === 'active' ? 'success' : ($partner->status === 'inactive' ? 'secondary' : 'warning') }}">
                        {{ ucfirst($partner->status) }}
                    </span>
                </p>
                <p><strong>Address:</strong> {{ $partner->address ?? 'N/A' }}</p>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card stat-card">
            <div class="card-body">
                <h5>Total Customers</h5>
                <h2>{{ $partner->customers->count() }}</h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card stat-card success">
            <div class="card-body">
                <h5>Total Loans</h5>
                <h2>{{ $partner->loans->count() }}</h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card stat-card info">
            <div class="card-body">
                <h5>Total Savings</h5>
                <h2>{{ $partner->savings->count() }}</h2>
            </div>
        </div>
    </div>
</div>
@endsection

