<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::updateOrCreate(
            ['email' => 'admin@microloan.com'],
            [
                'name' => 'Admin User',
                'role' => 'admin',
            ]
        );
        
        // Set password directly to avoid double-hashing from the 'hashed' cast
        $user->password = Hash::make('admin123');
        $user->save();
    }
}
