<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('savings_schemes', function (Blueprint $table) {
            $table->enum('compounding_frequency', ['monthly', 'quarterly', 'yearly'])->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('savings_schemes', function (Blueprint $table) {
            $table->enum('compounding_frequency', ['monthly', 'quarterly', 'yearly'])->nullable(false)->change();
        });
    }
};
