<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('savings', function (Blueprint $table) {
            $table->enum('savings_type', ['RD', 'FD', 'MIS'])->default('RD')->after('type');
            $table->decimal('principal_amount', 15, 2)->nullable()->after('target_amount');
            $table->decimal('monthly_deposit', 15, 2)->nullable()->after('principal_amount');
            $table->enum('interest_type', ['simple', 'compound'])->default('compound')->after('interest_rate');
            $table->enum('compounding_frequency', ['monthly', 'quarterly', 'yearly'])->default('monthly')->after('interest_type');
            $table->decimal('maturity_amount', 15, 2)->nullable()->after('collected_amount');
            $table->decimal('monthly_interest_payout', 15, 2)->nullable()->after('maturity_amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('savings', function (Blueprint $table) {
            $table->dropColumn([
                'savings_type',
                'principal_amount',
                'monthly_deposit',
                'interest_type',
                'compounding_frequency',
                'maturity_amount',
                'monthly_interest_payout'
            ]);
        });
    }
};
