<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('savings', function (Blueprint $table) {
            $table->decimal('target_amount', 15, 2)->nullable()->after('amount');
            $table->decimal('collected_amount', 15, 2)->default(0)->after('target_amount');
            $table->decimal('installment_amount', 15, 2)->nullable()->after('collected_amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('savings', function (Blueprint $table) {
            $table->dropColumn(['target_amount', 'collected_amount', 'installment_amount']);
        });
    }
};
