<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            // Drop foreign key constraint first
            $table->dropForeign(['scheme_id']);
        });
        
        // Modify the column to be nullable
        Schema::table('loans', function (Blueprint $table) {
            $table->unsignedBigInteger('scheme_id')->nullable()->change();
        });
        
        // Re-add foreign key constraint
        Schema::table('loans', function (Blueprint $table) {
            $table->foreign('scheme_id')->references('id')->on('schemes')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            // Drop foreign key constraint
            $table->dropForeign(['scheme_id']);
        });
        
        // Make scheme_id required again
        Schema::table('loans', function (Blueprint $table) {
            $table->unsignedBigInteger('scheme_id')->nullable(false)->change();
        });
        
        // Re-add foreign key constraint
        Schema::table('loans', function (Blueprint $table) {
            $table->foreign('scheme_id')->references('id')->on('schemes')->onDelete('restrict');
        });
    }
};
