<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('savings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('partner_id')->constrained('partners')->onDelete('cascade');
            $table->foreignId('customer_id')->constrained('customers')->onDelete('cascade');
            $table->foreignId('scheme_id')->nullable()->constrained('schemes')->onDelete('set null');
            $table->string('savings_number')->unique();
            $table->decimal('amount', 15, 2);
            $table->decimal('interest_rate', 8, 2)->default(0);
            $table->date('deposit_date');
            $table->date('maturity_date')->nullable();
            $table->enum('type', ['deposit', 'withdrawal'])->default('deposit');
            $table->enum('status', ['active', 'matured', 'closed'])->default('active');
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('savings');
    }
};
