<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class LoanScheme extends Model
{
    protected $fillable = [
        'partner_id',
        'name',
        'description',
        'interest_rate',
        'interest_type',
        'duration_type',
        'duration_value',
        'min_amount',
        'max_amount',
        'processing_fee',
        'insurance_fee',
        'other_fee',
        'late_fee_type',
        'late_fee_value',
        'status',
    ];

    protected function casts(): array
    {
        return [
            'interest_rate' => 'decimal:2',
            'min_amount' => 'decimal:2',
            'max_amount' => 'decimal:2',
            'processing_fee' => 'decimal:2',
            'insurance_fee' => 'decimal:2',
            'other_fee' => 'decimal:2',
            'late_fee_value' => 'decimal:2',
        ];
    }

    public function partner(): BelongsTo
    {
        return $this->belongsTo(Partner::class);
    }

    public function loans(): HasMany
    {
        return $this->hasMany(Loan::class, 'loan_scheme_id');
    }
}
