<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckSubscription
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth()->user();
        
        // Skip check for admin users
        if ($user && $user->role === 'admin') {
            return $next($request);
        }
        
        // Allow subscription routes, logout, and theme toggle
        if ($request->routeIs('partner.subscription.*') || 
            $request->routeIs('logout') || 
            $request->routeIs('theme.toggle')) {
            return $next($request);
        }

        // Check if partner has active subscription
        if ($user && $user->partner) {
            $activeSubscription = $user->partner->activeSubscription();
            
            if (!$activeSubscription) {
                return redirect()->route('partner.subscription.index')
                    ->with('error', 'Your subscription has expired or is inactive. Please subscribe to continue using the platform.');
            }
            
            // Check if subscription is expired
            if ($activeSubscription->end_date && $activeSubscription->end_date->isPast()) {
                return redirect()->route('partner.subscription.index')
                    ->with('error', 'Your subscription has expired. Please renew your subscription to continue.');
            }
        }

        return $next($request);
    }
}
