<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Partner;
use Carbon\Carbon;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        // Admin Dashboard - Only Partner Statistics
        $stats = [
            'total_partners' => Partner::count(),
            'active_partners' => Partner::where('status', 'active')->count(),
            'inactive_partners' => Partner::where('status', 'inactive')->count(),
        ];

        // Partner status distribution
        $partnerStatusData = Partner::selectRaw('status, COUNT(*) as count')
            ->groupBy('status')
            ->get()
            ->pluck('count', 'status')
            ->toArray();

        // Recent partners
        $recentPartners = Partner::latest()->take(5)->get();

        return view('admin.dashboard', compact(
            'stats',
            'partnerStatusData',
            'recentPartners'
        ));
    }
}
