<?php

namespace App\Console\Commands;

use App\Services\LateFeeService;
use Illuminate\Console\Command;

class ApplyLateFees extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'loans:apply-late-fees';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Apply late fees for all overdue loans';

    /**
     * Execute the console command.
     */
    public function handle(LateFeeService $lateFeeService)
    {
        $this->info('Checking for overdue loans...');
        
        $count = $lateFeeService->applyLateFeesForAllOverdueLoans();
        
        $this->info("Late fees applied for {$count} overdue loan(s).");
        
        return Command::SUCCESS;
    }
}
